package cn.gtmap.realestate.supervise.portal.service;


import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtResource;
import cn.gtmap.realestate.supervise.portal.utils.RSAUtils;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hqz
 * @version 1.0, 2017/5/25
 * @description 用户登录信息验证
 */
@Service
public class CustomUserDetailsService implements UserDetailsService {

    private XtUserService xtUserService;

    private UserCache userCache;

    private static final String role_admin = AppConfig.getProperty("role.admin");

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {

        UserAuthDTO user;
        try {

            //取得用户的密码
            String loginName;
            String token = "";
            if (StringUtils.contains(username, "_token_")) {
                String[] users = username.split("_token_");
                loginName = users[0];
                token = users[1];
            } else {
//                loginName = username;
                loginName = RSAUtils.decryptDataOnJava(username);
            }
            user = xtUserService.loadUserByUserName(loginName);
            if (null == user || null == user.getXtUser()) {
                throw new UsernameNotFoundException(username);
            }
            //得到用户的权限
            Collection<GrantedAuthority> auths = xtUserService.loadUserAuthoritiesByUserName(user.getXtUser().getUserId());
            user.setAuthorities(auths);

            LinkedHashMap<String, LinkedHashMap<String, XtResource>> resources = null;
            for (GrantedAuthority ga : auths) {
                if (role_admin.trim().equals(ga.getAuthority().trim())) {
                    //具有管理员权限的加载全部菜单
                    resources = xtUserService.findAdminResource(token);
                    user.setIsAdmin(true);
                    //获取当前用户所具有的最高行政区权限
                    List<Map<String, Object>> regions = xtUserService.loadUserMaxRegionByUserId(user.getXtUser().getUserId());
                    user.setRegions(regions);
                }
            }

            if (null == resources) {
                //获取当前用户所具有的菜单权限
                resources = xtUserService.loadUserResourcesByUserId(user.getXtUser().getUserId(), token);
                user.setIsAdmin(false);
                //获取当前用户所具有的最高行政区权限
                List<Map<String, Object>> regions = xtUserService.loadUserMaxRegionByUserId(user.getXtUser().getUserId());
                user.setRegions(regions);
            }

            user.setResourceMap(resources);
            if (StringUtils.isNotBlank(token)) {
                user.setToken(token);
                user.setPassword("token");
            }

        } catch (Exception e) {
            throw new UsernameNotFoundException(username);
        }

        return user;
    }

    //设置用户缓存功能。
    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public XtUserService getXtUserService() {
        return xtUserService;
    }

    public void setXtUserService(XtUserService xtUserService) {
        this.xtUserService = xtUserService;
    }
}
