package cn.gtmap.realestate.supervise.portal.security;

import cn.gtmap.realestate.supervise.portal.model.RoleResourceDTO;
import cn.gtmap.realestate.supervise.portal.service.RoleResourceService;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

import java.util.*;

/**
 * @author hqz
 * @version 1.0, 2017/5/25
 * @description 系统启动加载系统权限  用户登入验证权限
 */
public class MySecurityMetadataSource implements FilterInvocationSecurityMetadataSource {

    /**
     * 资源map
     */
    private Map<String, Collection<ConfigAttribute>> resourceMap = null;

    private static final String loginUrl = "/login";

    private static final String groupNo = "realestate-supervise-portal";

    private static final String  role_admin = AppConfig.getProperty("role.admin");

    private RoleResourceService roleResourceService;

    //由spring调用
    public MySecurityMetadataSource(){

    }

    @Override
    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        loadResourceDefine();
        // object 是一个URL，被用户请求的url。
        FilterInvocation filterInvocation = (FilterInvocation) object;
        Iterator<String> ite = resourceMap.keySet().iterator();

        ConfigAttribute configAttribute = new SecurityConfig(role_admin);
        while (ite.hasNext()) {
            String requestURL = ite.next();
            if(StringUtils.isNotBlank(requestURL)) {
                //登录请求过滤掉 因为需要security的过滤器，所以不能在配置文件中过滤
                if (StringUtils.equals(requestURL, loginUrl)) {
                    return null;
                }
                RequestMatcher requestMatcher = new AntPathRequestMatcher(requestURL);
                if (requestMatcher.matches(filterInvocation.getHttpRequest())) {
                    //超级管理员也可访问，无需配置
                    Collection<ConfigAttribute> configAttributes = resourceMap.get(requestURL);
                    configAttributes.add(configAttribute);
                    return configAttributes;
                }
            }
        }
        //未配置的资源可以直接访问
        return null;
    }

    @Override
    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return new ArrayList();
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return true;
    }

    //加载所有资源与权限的关系
    private void loadResourceDefine() {
//        if (resourceMap == null) {
            resourceMap = new HashMap();
            List<RoleResourceDTO> resources = roleResourceService.findRoleResourceDTO(groupNo);
            Collection<ConfigAttribute> configAttributes;
            if (CollectionUtils.isNotEmpty(resources)) {
                for (RoleResourceDTO resource : resources) {
                    if (resourceMap.containsKey(resource.getInterceptUrl())) {
                        configAttributes = resourceMap.get(resource.getInterceptUrl());
                    } else {
                        configAttributes = new ArrayList();
                    }
                    // 以权限名封装为Spring的security Object
                    //resource.getRoleName() 角色名称 可随意 role_admin  或者 admin
                    ConfigAttribute configAttribute =
                            new SecurityConfig(resource.getRoleNo());
                    configAttributes.add(configAttribute);
                    //resource.getInterceptUrl() 格式必须是 拦截的包路径
                    resourceMap.put(resource.getInterceptUrl(), configAttributes);
                }
            }
//        }

    }

    public RoleResourceService getRoleResourceService() {
        return roleResourceService;
    }

    public void setRoleResourceService(RoleResourceService roleResourceService) {
        this.roleResourceService = roleResourceService;
    }

}
