package cn.gtmap.realestate.supervise.portal.security;

import cn.gtmap.realestate.supervise.portal.utils.LoginUserUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * @author hqz
 * @version 1.0, 2017/6/8
 * @description 自定义退出事件
 */
public class MyLogoutSuccessHandler implements LogoutSuccessHandler {
    /**
     * 平台统一定义cookie名
     */
    private String cookieName;

    /**
     * 默认跳转页面
     */
    private String defaultTargetUrl;

    /**
     * 默认是否跳转
     */
    private String defaultTargetFlag;

    private static final String DEFAULT_TARGET_FLAG = "true";

    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    @Override
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        Cookie[] diskCookies = request.getCookies();
        String cookieValue;
        if(diskCookies != null) {
            for(int problem = 0; problem < diskCookies.length; ++problem) {
                if(diskCookies[problem].getName().equals(cookieName)) {
                    cookieValue = diskCookies[problem].getValue();
                    LoginUserUtil.loginOutHandle(cookieValue);
                }
            }
        }

        // 删除 cookie
        Cookie ssoCookie = new Cookie(this.cookieName, cookieName);
        ssoCookie.setMaxAge(0);
        ssoCookie.setPath("/");
        response.addCookie(ssoCookie);

        if(StringUtils.isNotBlank(defaultTargetFlag) && StringUtils.equals(defaultTargetFlag,DEFAULT_TARGET_FLAG)){
            sendJsonViaReponse(response, new Object());
        }else{
            this.redirectStrategy.sendRedirect(request, response, this.defaultTargetUrl);
        }
    }

    private void sendJsonViaReponse(HttpServletResponse response, Object data){
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = null ;
        JSONObject res = new JSONObject();
        res.put("data", data);
        res.put("msg", "success");
        try {
            out = response.getWriter();
            out.append(res.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCookieName() {
        return cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getDefaultTargetUrl() {
        return defaultTargetUrl;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        this.defaultTargetUrl = defaultTargetUrl;
    }

    public String getDefaultTargetFlag() {
        return defaultTargetFlag;
    }

    public void setDefaultTargetFlag(String defaultTargetFlag) {
        this.defaultTargetFlag = defaultTargetFlag;
    }
}
