package cn.gtmap.realestate.supervise.portal.security;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.portal.utils.LockUserUtil;
import cn.gtmap.realestate.supervise.portal.utils.LoginUserUtil;
import cn.gtmap.realestate.supervise.portal.utils.RSAUtils;
import cn.gtmap.realestate.supervise.utils.AESSecutiryUtil;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.alibaba.fastjson.JSONObject;
import com.thoughtworks.xstream.InitializationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author hqz
 * @version 1.0, 2017/6/8
 * @description 自定义登录成功事件
 */
public class MyLoginSuccessHandler implements AuthenticationSuccessHandler, InitializingBean {

    /**
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 平台统一定义cookie名
     */
    private String cookieName;

    /**
     * 默认跳转页面
     */
    private String defaultTargetUrl;

    /**
     * 默认是否跳转
     */
    private String defaultTargetFlag;

    private static final String DEFAULT_TARGET_FLAG = "true";

    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isEmpty(cookieName)) {
            throw new InitializationException("You must configure cookieName");
        }
    }

    @Override
    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication)
        throws IOException {
        String password = request.getParameter("password");
        password = RSAUtils.decryptDataOnJava(password);
        String regex = "^(?=.*?[a-z])(?=.*?[A-Z])(?=.*?\\d)[a-zA-Z\\d!#@*&._]*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);

        UserAuthDTO userAuthDTO = (UserAuthDTO) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (null == userAuthDTO) {
            return;
        }

        if (matcher.matches()) {
            if (password.length() >= 8) {
                userAuthDTO.setPasswordTooSimple(false);
            } else {
                userAuthDTO.setPasswordTooSimple(true);
            }
        } else {
            userAuthDTO.setPasswordTooSimple(true);
        }

        LockUserUtil.unSetLockHandle(userAuthDTO.getUsername());

        String newID = createUID(IpUtil.getIpAddr(request));

        StringBuilder builder = new StringBuilder();
        builder.append(cookieName +"=" + newID + "; ");
        builder.append("HttpOnly; ");
        builder.append("max_age=None; ");
        builder.append("path=/ ");
        response.addHeader("Set-Cookie",builder.toString());

        LoginUserUtil.loginSuccessHandle(newID, userAuthDTO);
        OperationalLogUtil.log(request, userAuthDTO.getXtUser().getUserName(),"3", "用户登录", "基础支撑平台");

        if (StringUtils.isNotBlank(defaultTargetFlag) && StringUtils.equals(defaultTargetFlag, DEFAULT_TARGET_FLAG)) {

            sendJsonViaReponse(response, userAuthDTO);
        } else {
            this.redirectStrategy.sendRedirect(request, response, this.defaultTargetUrl);
        }

    }

    public String getCookieName() {
        return cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    private static String createUID(String ip) {
        Date now = new Date();
        long time = now.getTime();
        return "gtmap" + time + "ip" + AESSecutiryUtil.encrypt(ip);
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        this.defaultTargetUrl = defaultTargetUrl;
    }

    public void setDefaultTargetFlag(String defaultTargetFlag) {
        this.defaultTargetFlag = defaultTargetFlag;
    }

    private void sendJsonViaReponse(HttpServletResponse response, Object data) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out;
        JSONObject res = new JSONObject();
        res.put("data", data);
        res.put("msg", "success");
        try {
            out = response.getWriter();
            out.append(res.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
