package cn.gtmap.realestate.supervise.portal.security;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * @author hqz
 * @version 1.0, 2017/6/8
 * @description 自定义登录失败事件
 */
public class MyLoginFailureHandler implements AuthenticationFailureHandler, InitializingBean {

    /**
     * 默认跳转页面
     */
    private String defaultTargetUrl;

    /**
     * 默认是否跳转
     */
    private String defaultTargetFlag;

    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();


    @Override
    public void afterPropertiesSet() {

    }

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response,
                                        AuthenticationException e) throws IOException {
        if (StringUtils.isNotBlank(defaultTargetFlag) && "true".equals(defaultTargetFlag)) {
            sendJsonViaReponse(response, new Object());
        } else {
            this.redirectStrategy.sendRedirect(request, response, this.defaultTargetUrl);
        }
    }

    private void sendJsonViaReponse(HttpServletResponse response, Object data) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        JSONObject res = new JSONObject();
        res.put("data", data);
        res.put("msg", "failure");
        try {
            PrintWriter out = response.getWriter();
            out.append(res.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDefaultTargetUrl() {
        return defaultTargetUrl;
    }

    public void setDefaultTargetUrl(String defaultTargetUrl) {
        this.defaultTargetUrl = defaultTargetUrl;
    }

    public String getDefaultTargetFlag() {
        return defaultTargetFlag;
    }

    public void setDefaultTargetFlag(String defaultTargetFlag) {
        this.defaultTargetFlag = defaultTargetFlag;
    }
}
