package cn.gtmap.realestate.supervise.portal.model;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * @author hqz
 * @version 1.0, 2017/6/8
 * @description 登录用户缓存存储类（线程安全，单例）
 */
public class LoginUserCache {

    private ConcurrentMap loginUser;

    private static LoginUserCache instance;

    private LoginUserCache() {
        loginUser = new ConcurrentHashMap();
    }

    public static synchronized LoginUserCache getInstance() {
        if (instance == null) {
            instance = new LoginUserCache();
        }
        return instance;
    }

    public ConcurrentMap getLoginUser() {
        return loginUser;
    }

    public void setLoginUser(ConcurrentMap loginUser) {
        this.loginUser = loginUser;
    }
}
