package cn.gtmap.realestate.supervise.portal.model;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * @author hqz
 * @version 1.0, 2017/6/8
 * @description 锁定登录用户缓存存储类（线程安全，单例）
 */
public class LockUserCache {

    private ConcurrentMap lockUser;

    private static LockUserCache instance;

    private LockUserCache() {
        lockUser = new ConcurrentHashMap();
    }

    public static synchronized LockUserCache getInstance() {
        if (instance == null) {
            instance = new LockUserCache();
        }
        return instance;
    }

    public ConcurrentMap getLockUser() {
        return lockUser;
    }

    public void setLockUser(ConcurrentMap lockUser) {
        this.lockUser = lockUser;
    }
}
