package cn.gtmap.realestate.supervise.portal.dao;

import cn.gtmap.realestate.supervise.entity.XtUser;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * @author hqz
 * @version 1.0, 2017/5/25
 * @description 系统用户持久操作层
 */
@Repository
public interface XtUserMapper {


    /**
     * 根据username 获取唯一用户
     * @param username
     * @return
     */
    XtUser loadUserByUserName(String username);


    /**
     * 根据username 获取用户角色
     * @param username
     * @return
     */
    List<Map<String, Object>> getRolesByUserName(String username);

    /**
     * 保存新建的用户信息
     * @param user
     */
    void saveUser(XtUser user);


    /**
     * 根据主键删除记录（user_id）
     */
    void deleteByPrimaryKey(String userid);

    /**
     * 根据主键（user_id）来更改用户状态（is_valid）
     */
    void changeValid(Map map);

    /**
     * 更改用户的信息
     */
    void updateUser(XtUser xtUser);

    /**
     * 通过登录名获取用户
     */
    XtUser getUserByLoginName(@Param(value = "loginName") String loginName);

    /**
     * 通过用户编码获取用户
     */
    XtUser getUserById(@Param(value = "id") String id);

    List<Map> getAllXtUser();

    /**
     * 根据key值获取参数值
     * @param propertiesKey
     * @return
     */
    String getXtPropertiesByKey(@Param(value="propertiesKey") String propertiesKey);

    /**
     * 根据登录名获取前几次密码
     * @param loginName 登录名
     * @param passwordDiffTime 次数
     * @return
     */
    List<Map<String, String>> getPasswordLogByLoginName(@Param(value = "loginName") String loginName,@Param(value = "passwordDiffTime") String passwordDiffTime);

    /**
     * 保存修改的密码信息
     * @param loginName 登录名
     * @param password 密码
     * @param updateTime 修改时间
     */
    void saveNewPasswordLog(@Param(value = "loginName") String loginName,@Param(value = "password") String password,@Param(value = "updateTime") Date updateTime);
}
