package cn.gtmap.realestate.supervise.portal.dao;

import cn.gtmap.realestate.supervise.entity.XtRole;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


/**
 * @author zhangyu
 * @version 1.0, 2017/6/19
 * @description 系统角色持久操作层
 */
@Repository
public interface XtRoleMapper {


    /**
     * 新增角色
     */
    int addRole(XtRole xtRole);

    /**
     * 编辑角色
     */
    int updateByRoleId(XtRole xtRole);

    /**
     * 删除选中角色
     */
    int delSelectByRoleId(String selectDel);

    /**
     * 根据userid和已有roleID 获取用户角色
     * @param map
     * @return
     */
    List<Map<String,Object>> getAllRole(Map map);

    /**
     * 根据roleNo判断唯一性
     */
    XtRole getRoleByRoleNo(String roleno);

    /**
     * 根据角色id获取角色名称
     * @param roleId
     * @return
     */
    String getRoleNameById(String roleId);

}
