package cn.gtmap.realestate.supervise.portal.dao;



import cn.gtmap.realestate.supervise.entity.XtResource;

import cn.gtmap.realestate.supervise.entity.XtResourceButtonRel;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


/**
 * @author zhangyu
 * @version 1.0, 2017/6/19
 * @description 系统资源持久操作层
 */
@Repository
public interface XtResourceMapper {


    /**
     * 新增资源
     */
    int addResource(XtResource xtResource);

    /**
     * 编辑资源
     */
    int updateResource(Map map);

    /**
     * 删除选中资源
     */
    int delSelectByResourceId(String selectDel);

    List getChildNodes(Map map);


    /**
     * 编辑资源父Id
     */
    int updateParResourceId(Map map);

    /**
     * 通过资源主键更新资源
     */
    int updateResourceByKey(XtResource xtResource);

    /**
     * 根据userId和已有roleID 获取用户资源
     * @param map
     * @return
     */
    List<Map<String,Object>> getLeftResource(Map map);

    /**
     * 根据userId和已有roleID 获取用户资源
     * @param map
     * @return
     */
    List<Map<String,Object>> getRightResource(Map map);


    XtResource getResource(Map map);

    XtResource getResourceById(String resourceId);

    List<XtResource> listResource(Map map);

    List<Map<String,Object>> getGroup();

    /**
     * 通过资源ID获取该资源下拥有哪些按钮权限
     * @param resourceId
     * @return
     */
    List<Map> getButtonsByres(Map resourceId);

    /**
     * 通过资源ID获取资源按钮关系表记录
     * @param resourceId
     * @return
     */
    List<XtResourceButtonRel> getRBrelByRId(Map resourceId);

    /**
     * 保存xt_resource_button_rel
     * @param xtResourceButtonRel
     * @return
     */
    int saveRBrels(XtResourceButtonRel xtResourceButtonRel);

    /**
     * 根据resource_id删除xt_resource_button_rel表中的记录
     * @param resourceId
     * @return
     */
    int delRBrelsByresId(Map resourceId);
}
