package cn.gtmap.realestate.supervise.portal.dao;

import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/23
 * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
 * @description 系统部门操作持久层
 */
@Repository
public interface XtRegionMapper {
    /**
     * 查询Xzqh行政区划信息
     * @param map
     * @return XtXzqh
     */
    XtRegion getXzqh(Map map);

    /**
     * 删除Xzqh行政区划信息
     * @param map
     * @return
     */
    void delXzqhByIds(Map map);

    /**
     * 父代码删除
     * @param fdm
     */
    void updateParentRegin(String fdm);

    /**
     * 获取行政区划分页信息
     * @param map
     * @return
     */
    List<Map<String,Object>> getXzqhByPage(Map map);

    /**
     * 根据角色编码获取行政区
     * @param roleId 角色编码
     * @return 父地区
     */
    List<XtRegion> getRegionByRole(String roleId);

    /**
     * 根据配置的根qhdm获取所有的xzqh
     * @param root_qhdm
     * @return
     */
    List<Map> getLRXzqhs(Map root_qhdm);

    /**
     * 根据userid和已有roleID 获取用户角色
     * @param map
     * @return
     */
    List<Map<String,Object>> getLeftXzqhs(Map map);

    /**
     * 根据userid和已有roleID 获取用户角色
     * @param map
     * @return
     */
    List<Map<String,Object>> getRightXzqhs(Map map);

    /**
     * 根据roleID 获取行政区划
     * @param roleid
     * @return
     */
    List<String> getXzqhsByRoleId(Map roleid);


    /**
     * 根据fdm 获取子行政区划
     * @param fdmAndLevel
     * @return
     */
    List<Map<String,Object>> getChildNodes(Map fdmAndLevel);

    /**
     * 根据fdm 获取子行政区划
     * @param fdmAndLevel
     * @return
     */
    List<XtRegion> getXzqhNext(Map fdmAndLevel);

    /**
     * 根据USERID 获取当前用户所拥有的行政区划
     * @param userid
     * @return
     */
    List<XtRegion> getCurruserRegion(Map userid);

    /**
     * 根据USERID 获取当前用户所拥有的系统列表
     * @param userid
     * @return
     */
    List<XtGroup> getCurruserGroup(Map userid);


}
