package cn.gtmap.realestate.supervise.portal.dao;

import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtResourceGroupRel;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @author lww
 * @version 1.0, 2017/5/25
 * @description 系统用户持久操作层
 */
@Repository
public interface XtGroupMapper {

    /**
     * 查询所有的group信息
     * @param
     */
    List<XtGroup> getAllgroup();

    /**
     * 保存新建的group信息
     * @param
     */
    void saveGroup(XtGroup group);


    /**
     * 根据主键删除记录（group_id）
     */
    void deleteByPrimaryKey(String groupid);


    /**
     * 更改group的信息
     */
    void updateGroup(XtGroup group);

    /**
     * 根据主键查询group信息
     */
    XtGroup selectByPrimaryKey(String groupid);

    /**
     * 根据groupid查resource_group_rel信息
     */
    List<XtResourceGroupRel> getRGRByGroupid(String groupid);

    /**
     * 保存resource_group_rel信息
     */
    void saveRGR(XtResourceGroupRel xtRgr);

    /**
     * 根据groupNo判断唯一性
     */
    XtGroup getGroupByGroupNo(String groupno);

    /**
     * 根据groupId获取子系统信息
     * @param groupId
     * @return
     */
    XtGroup getGroupByGroupId(String groupId);


}
