package cn.gtmap.realestate.supervise.portal.dao;
import cn.gtmap.realestate.supervise.entity.XtDate;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;
import java.util.Date;
import java.util.List;
/**
 * @author wangyang
 * @version 1.0, 2018/8/6
 * @description  "系统日历的持久层"
 */
@Repository
public interface XtDateMapper {

    /**
     * 插入所选年份的信息
     */
    void insertEveryDay(List<XtDate> everydaylist);

    /**
     * 查询系统当月的信息
     */
    List<XtDate> selectMonthDay();

    /**
     * 更新具体一天的信息
     */
    void  updateDateType(@Param("id")String id,@Param("xttype")Integer xttype,@Param("xttext") String xttext);

    /**
     *通过月份获得当月的的所有信息
     */
    List<XtDate>  selectDayByMonth(@Param(("my"))String yearandmonth);

    /**
     *通过具体时间获得相对应的一条记录
     */
    XtDate  selectOneDayByDate(@Param("date")Date sdate);

    /**
     *通过id获得相对应的一条记录
     */
    XtDate  selectOneDayById(@Param("id")String id);

}
