package cn.gtmap.realestate.supervise.portal.dao;

import cn.gtmap.realestate.supervise.entity.XtButton;
import cn.gtmap.realestate.supervise.entity.XtResource;
import cn.gtmap.realestate.supervise.entity.XtResourceRoleRel;
import cn.gtmap.realestate.supervise.entity.XtRole;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;


/**
 * @author zhangyu
 * @version 1.0, 2017/5/27
 * @description 资源权限
 */
@Repository
public interface RoleResourceMapper {


    /**
     * 获取所有的资源信息
     * @return 所有的资源信息
     */
    public List<XtResource> getAllResource(String groupNo);

    /**
     * 通过资源ID找到对应的角色信息
     * @return 资源所需要的角色信息
     */
    public List<XtRole> getRoleByResource(@Param("resourceId") String resourceId);


    /**
     * 通过用户ID找到对应的角色信息
     * @return 用户所具有的角色信息
     */
    public List<XtRole> getRoleByUserName(@Param("userId") String userId);

    /**
     * 根据条件获取资源信息
     * @return 对应的资源信息
     */
    public List<XtResource> getResourceByMap(Map<String,String> parMap);

    /**
     * 根据角色获取资源集合
     * @param roleId 角色编码
     * @return 资源集合
     */
    public List<XtResource> getResourceByRole(String roleId);

    /**
     * 根据角色获取资源集合
     * @return 资源集合
     */
    public List<XtResource> getResourceByAdmin();

    /**
     * 根据父资源获取子资源集合
     * @return 子资源集合
     */
    public List<XtResource> getAdminResourceByParent(String parentId);

    /**
     * 根据父资源获取子资源集合
     * @param param 查询条件
     * @return 子资源集合
     */
    public List<XtResource> getResourceByParent(Map<String,String> param);

    /**
     * 根据resourceId和roleId 获取用户角色关系表
     * @param map
     * @return
     */
    public XtResourceRoleRel getRRrel(Map map);

    /**
     * 根据资源编码获取资源所具有的按钮权限
     * @param resourceId 资源ID
     * @return 按钮权限集合
     */
    public List<XtButton> getButtonByResourceId(String resourceId);
}
