package cn.gtmap.realestate.supervise.portal.checkjob;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.portal.model.LockUserCache;
import cn.gtmap.realestate.supervise.portal.model.LoginUserCache;
import com.gtis.config.AppConfig;
import org.joda.time.DateTime;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

/**
 * 定时任务去除已经登陆超时的用户
 *
 * @version 1.0 2019-5-29
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
@Component
public class CheckJob {

    /**
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 超时时间 application.properties 配置文件中的 session.time.out 配置项
     */
    private Integer timeout = AppConfig.getIntProperty("session.time.out");

    /**
     * 超时时间 application.properties 配置文件中的 lock.time.out 配置项
     */
    private Integer lockTimeout = AppConfig.getIntProperty("lock.time.out");

    /**
     * 清除登陆用户
     */
    public void checkUserTimeOut() {
        logger.debug("clear loginUserCache - {}", new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
        LoginUserCache loginUserCache = LoginUserCache.getInstance();
        ConcurrentMap loginMap = loginUserCache.getLoginUser();
        Iterator<ConcurrentMap.Entry> entries = loginMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            DateTime statusDate = new DateTime(((UserAuthDTO) entry.getValue()).getStatusDate());
            DateTime now = new DateTime(new Date());
            statusDate = statusDate.plusMinutes(timeout);
            if (statusDate.isBefore(now)) {
                loginMap.remove(entry.getKey());
            }
        }
        logger.debug("loginMap:{}", loginMap.size());
    }

    /**
     * 锁定用户清除
     */
    public void checkUserLockTimeOut() {
        logger.debug("clear lockUserCache - {}", new DateTime().toString("yyyy-MM-dd HH:mm:ss"));
        LockUserCache lockUserCache = LockUserCache.getInstance();
        ConcurrentMap lockMap = lockUserCache.getLockUser();
        Iterator<ConcurrentMap.Entry> entries = lockMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if(null != entry && null != entry.getValue() && ((UserAuthDTO) entry.getValue()).getLoginLocked()){
                DateTime lockDate = new DateTime(((UserAuthDTO) entry.getValue()).getLockDate());
                DateTime now = new DateTime(new Date());
                lockDate = lockDate.plusMinutes(lockTimeout);
                if (lockDate.isBefore(now)) {
                    lockMap.remove(entry.getKey());
                }
            }
        }
        logger.debug("lockMap:{}", JSONObject.toJSONString(lockMap));
    }

}
