/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.model.yw_encrypt;

import cn.gtmap.realestate.supervise.common.FieldSign;
import com.jmj.FMException;
import com.jmj.FmBaseApi;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YwApi {
    private static final Logger logger = LoggerFactory.getLogger(YwApi.class);
    private static final int SM4_ENCRYPT_MODEL = 1;
    private static final int SM4_DECRYPT_MODEL = 2;
    private static FmBaseApi fmapi;
    private static String password;
    private static int KEY_NUM;
    private static int FME_OK;
    public static final String prefix = "pamtgms";
    public static final String CONCAT_SYMBOL_EQ = "=";
    public static final String CONCAT_SYMBOL_AND = "&";
    public static final String SPLIT_STR_COMMA = ",";

    public static void getConnect() {
        if (null == fmapi) {
            fmapi = FmBaseApi.getInstance();
        }
        try {
            fmapi.FM_CPC_OpenDevice(password.getBytes());
        }
        catch (FMException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6e14\u7fc1\u52a0\u5bc6\u673a\u8fde\u63a5\u5f02\u5e38");
        }
    }

    public static void close() {
        if (null == fmapi) {
            fmapi = FmBaseApi.getInstance();
        }
        fmapi.FM_CPC_CloseDevice();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String sm4EncryptHexStr(String sm4Indata) {
        StringBuilder ret_sm4Indata = new StringBuilder("");
        try {
            if (null == sm4Indata || sm4Indata.startsWith(prefix)) return sm4Indata;
            String[] sm4IndataArr = StringUtils.split((String)sm4Indata, (String)SPLIT_STR_COMMA);
            if (sm4IndataArr.length <= 0) return ret_sm4Indata.toString();
            for (String sm4IndataTemp : sm4IndataArr) {
                if (StringUtils.length((CharSequence)ret_sm4Indata) > 3500) return ret_sm4Indata.toString();
                byte[] inData = YwApi.padding(sm4IndataTemp.getBytes("UTF-8"), 1);
                byte[] endata = new byte[inData.length];
                int[] oulen = new int[1];
                int rv = fmapi.FM_CPC_Encrypt(KEY_NUM, 8, 0, inData, inData.length, endata, oulen, null, 0, null, 0);
                if (rv != FME_OK) {
                    logger.error(sm4Indata + "SM4\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_Encrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    throw new RuntimeException(sm4Indata + "SM4\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_Encrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                }
                String xx = prefix + Hex.encodeHexString((byte[])endata);
                ret_sm4Indata = StringUtils.isNotBlank((CharSequence)ret_sm4Indata) ? ret_sm4Indata.append(SPLIT_STR_COMMA).append(xx) : ret_sm4Indata.append(xx);
            }
            return ret_sm4Indata.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return ret_sm4Indata.toString();
    }

    public static String sm4DecryptHexStr(String sm4HexData) {
        StringBuilder ret_sm4HexData;
        block7: {
            ret_sm4HexData = new StringBuilder("");
            try {
                if (StringUtils.isNotBlank((CharSequence)sm4HexData) && sm4HexData.startsWith(prefix)) {
                    String[] sm4HexDataArr = StringUtils.split((String)sm4HexData, (String)SPLIT_STR_COMMA);
                    if (sm4HexDataArr.length > 0) {
                        for (String sm4HexDataTemp : sm4HexDataArr) {
                            byte[] inData = Hex.decodeHex((char[])sm4HexDataTemp.substring(prefix.length()).toCharArray());
                            byte[] outdata = new byte[inData.length];
                            int[] oulen = new int[1];
                            int rv = fmapi.FM_CPC_Decrypt(KEY_NUM, 8, 0, inData, inData.length, outdata, oulen, null, 0, null, 0);
                            if (rv != FME_OK) {
                                logger.error(sm4HexData + "SM4\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_Decrypt \u89e3\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                                throw new RuntimeException(sm4HexData + "SM4\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_Encrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                            }
                            byte[] res = YwApi.padding(outdata, 2);
                            String ret = new String(res, "UTF-8");
                            ret_sm4HexData = StringUtils.isNotBlank((CharSequence)ret_sm4HexData) ? ret_sm4HexData.append(SPLIT_STR_COMMA).append(ret) : ret_sm4HexData.append(ret);
                        }
                    }
                    break block7;
                }
                return sm4HexData;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (DecoderException e) {
                e.printStackTrace();
            }
        }
        return ret_sm4HexData.toString();
    }

    public static String sm4EncryptBase64Str(String sm4Indata) {
        try {
            if (null != sm4Indata && !sm4Indata.startsWith(prefix)) {
                byte[] inData = YwApi.padding(sm4Indata.getBytes("UTF-8"), 1);
                byte[] endata = new byte[inData.length];
                int[] oulen = new int[1];
                int rv = fmapi.FM_CPC_Encrypt(KEY_NUM, 8, 0, inData, inData.length, endata, oulen, null, 0, null, 0);
                if (rv != FME_OK) {
                    logger.error(sm4Indata + "SM4\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_Encrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    throw new RuntimeException(sm4Indata + "SM4\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_Encrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                }
                return prefix + Base64.encodeBase64String((byte[])endata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return sm4Indata;
    }

    public static String sm4DecryptBase64tr(String sm4Data) {
        try {
            if (StringUtils.isNotBlank((CharSequence)sm4Data) && sm4Data.startsWith(prefix)) {
                byte[] inData = Base64.decodeBase64((String)sm4Data.substring(prefix.length()));
                byte[] outdata = new byte[inData.length];
                int[] oulen = new int[1];
                int rv = fmapi.FM_CPC_Decrypt(KEY_NUM, 8, 0, inData, inData.length, outdata, oulen, null, 0, null, 0);
                if (rv != FME_OK) {
                    logger.error(sm4Data + "SM4\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_Decrypt \u89e3\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    throw new RuntimeException(sm4Data + "SM4\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_Decrypt \u89e3\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                }
                byte[] res = YwApi.padding(outdata, 2);
                return new String(res, "UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return sm4Data;
    }

    public static String sm2EncryptHexStr(String sm2Indata) {
        block3: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)sm2Indata)) break block3;
                byte[] inData = sm2Indata.getBytes("UTF-8");
                byte[] encData = new byte[260];
                int rv = fmapi.FM_CPC_ECCEncrypt(3, KEY_NUM, inData, inData.length, null, encData);
                if (rv != FME_OK) {
                    logger.error(sm2Indata + "SM2\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_ECCEncrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block3;
                }
                return Hex.encodeHexString((byte[])encData);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sm2Indata;
    }

    public static String sm2DecryptHexStr(String sm2Hexdata) {
        try {
            if (StringUtils.isNotBlank((CharSequence)sm2Hexdata)) {
                byte[] inData = Hex.decodeHex((char[])sm2Hexdata.toCharArray());
                byte[] outData = new byte[32];
                int[] outlen = new int[1];
                int rv = fmapi.FM_CPC_ECCDecrypt(3, KEY_NUM, inData, null, outData, outlen);
                if (rv != FME_OK) {
                    logger.error(sm2Hexdata + "SM2\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_ECCDecrypt \u89e3\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    throw new RuntimeException(sm2Hexdata + "SM2\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_ECCDecrypt \u89e3\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                }
                return new String(outData, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (DecoderException e) {
            e.printStackTrace();
        }
        return sm2Hexdata;
    }

    public static byte[] sm3Final(byte[] inData) {
        if (null != inData) {
            byte[] outdata = new byte[32];
            int[] outlen = new int[1];
            fmapi.FM_CPC_SM3Init(null, null, 0);
            fmapi.FM_CPC_SM3Update(inData, inData.length);
            int rv = fmapi.FM_CPC_SM3Final(outdata, outlen);
            if (rv != FME_OK) {
                logger.error("SM3Hash\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_SM3Final \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
            } else {
                return outdata;
            }
        }
        return null;
    }

    public static String sm3HMacHexStr(String sm3Indata) {
        block3: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)sm3Indata)) break block3;
                byte[] k0opad = new byte[64];
                byte[] ctx = new byte[512];
                byte[] inData = sm3Indata.getBytes("UTF-8");
                byte[] outdata = new byte[inData.length];
                int[] outlen = new int[1];
                fmapi.FM_CPC_HMAC_INIT_Ctx(KEY_NUM, null, 0, k0opad, ctx);
                fmapi.FM_CPC_HMAC_UPDATE_Ctx(inData, inData.length, ctx);
                int rv = fmapi.FM_CPC_HMAC_FINAL_Ctx(k0opad, ctx, outdata, outlen);
                if (rv != FME_OK) {
                    logger.error(sm3Indata + "SM3\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_SM3_Mac \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block3;
                }
                return Hex.encodeHexString((byte[])outdata);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sm3Indata;
    }

    public static String sm2Sign(String sm2SignData) {
        block4: {
            try {
                byte[] signData;
                if (!StringUtils.isNotBlank((CharSequence)sm2SignData)) break block4;
                if (sm2SignData.startsWith(prefix)) {
                    return sm2SignData;
                }
                byte[] inData = sm2SignData.getBytes("UTF-8");
                int rv = fmapi.FM_CPC_ECCSign(KEY_NUM, inData = YwApi.sm3Final(inData), inData.length, null, signData = new byte[64]);
                if (rv != FME_OK) {
                    logger.error(sm2SignData + "SM2\u7b7e\u540d\u5931\u8d25\uff01 FM_CPC_ECCSign \u7b7e\u540d\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block4;
                }
                return prefix + Hex.encodeHexString((byte[])signData);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sm2SignData;
    }

    public static boolean sm2VerifySign(String sm2InData, String sm2SignHexData) {
        block5: {
            try {
                byte[] signData;
                if (!StringUtils.isNotBlank((CharSequence)sm2InData) || !StringUtils.isNotBlank((CharSequence)sm2SignHexData)) break block5;
                if (sm2SignHexData.startsWith(prefix)) {
                    sm2SignHexData = sm2SignHexData.substring(prefix.length());
                }
                byte[] inData = sm2InData.getBytes("UTF-8");
                int rv = fmapi.FM_CPC_ECCVerify(KEY_NUM, null, inData = YwApi.sm3Final(inData), inData.length, signData = Hex.decodeHex((char[])sm2SignHexData.toCharArray()));
                if (rv != FME_OK) {
                    logger.error(sm2InData + "SM2\u9a8c\u7b7e\u5931\u8d25\uff01 FM_CPC_ECCVerify \u9a8c\u7b7e\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block5;
                }
                return true;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (DecoderException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static byte[] padding(byte[] input, int mode) {
        if (input == null) {
            return null;
        }
        if (mode == 1) {
            int p = 16 - input.length % 16;
            byte[] ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            ret[input.length + p - 1] = (byte)p;
            return ret;
        }
        if (mode == 2) {
            byte p = input[input.length - 1];
            byte[] ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
            return ret;
        }
        return input;
    }

    public static String getObjectSignStr(Object obj) {
        if (null != obj) {
            Field[] fields;
            StringBuilder res = new StringBuilder();
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                FieldSign fieldSign = field.getAnnotation(FieldSign.class);
                if (null == fieldSign) continue;
                try {
                    Object val = FieldUtils.readField((Field)field, (Object)obj, (boolean)true);
                    if (null == val) continue;
                    if (StringUtils.isNotBlank((CharSequence)res)) {
                        res.append(CONCAT_SYMBOL_AND).append(field.getName().toUpperCase()).append(CONCAT_SYMBOL_EQ).append(val.toString());
                        continue;
                    }
                    res.append(field.getName().toUpperCase()).append(CONCAT_SYMBOL_EQ).append(val.toString());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return res.toString();
        }
        return null;
    }

    static {
        password = "12345678";
        KEY_NUM = 1;
        FME_OK = 0;
    }
}

