/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.common;

import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import com.gtis.config.AppConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;

@Controller
public class BaseInfoController {
    @Value(value="${region.qhdm}")
    private String regionQhdm;
    @Value(value="${platform.cookiename}")
    private String platformCookiename;
    @Autowired(required=false)
    private SecuritySSOHandleService securitySSOHandleService;

    public String getRegionName() {
        String qhdm = AppConfig.getProperty((String)"region.qhdm");
        if (StringUtils.isEmpty((CharSequence)qhdm)) {
            qhdm = this.regionQhdm;
        }
        String regionName = "";
        if (StringUtils.isNotBlank((CharSequence)qhdm)) {
            XtRegion xtRegion;
            if (this.securitySSOHandleService == null) {
                this.securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            if (null != (xtRegion = this.securitySSOHandleService.getXzqhOne(qhdm))) {
                regionName = xtRegion.getQhmc();
            }
        }
        return regionName;
    }

    public List<XtRegion> getRegionLst() {
        String qhdm = AppConfig.getProperty((String)"region.qhdm");
        if (StringUtils.isEmpty((CharSequence)qhdm)) {
            qhdm = this.regionQhdm;
        }
        List<XtRegion> regionList = new ArrayList<XtRegion>();
        if (StringUtils.isNotBlank((CharSequence)qhdm)) {
            if (this.securitySSOHandleService == null) {
                this.securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            regionList = this.securitySSOHandleService.getXzqhNext(qhdm);
        }
        return regionList;
    }

    public List<XtRegion> getCurrRegionLst(String userid) {
        List<XtRegion> regionList = new ArrayList<XtRegion>();
        if (StringUtils.isNotBlank((CharSequence)userid)) {
            if (this.securitySSOHandleService == null) {
                this.securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            regionList = this.securitySSOHandleService.getCurruserRegion(userid);
        }
        return regionList;
    }

    public XtRegion getMaxRegion(String userid) {
        XtRegion xtRegion = new XtRegion();
        if (StringUtils.isNotBlank((CharSequence)userid)) {
            if (this.securitySSOHandleService == null) {
                this.securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            xtRegion = this.securitySSOHandleService.getMaxRegion(userid);
        }
        return xtRegion;
    }

    public List<XtGroup> getCurrGroupLst(String userid) {
        List<XtGroup> groupList = new ArrayList<XtGroup>();
        if (StringUtils.isNotBlank((CharSequence)userid)) {
            if (this.securitySSOHandleService == null) {
                this.securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            groupList = this.securitySSOHandleService.getCurruserGroup(userid);
        }
        return groupList;
    }

    public UserAuthDTO getCurrentUser(HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserAuthDTO userAuthDTO = null;
        if (null == authentication) {
            Cookie[] diskCookies;
            String cookieName = AppConfig.getProperty((String)"platform.cookiename");
            if (StringUtils.isEmpty((CharSequence)cookieName)) {
                cookieName = this.platformCookiename;
            }
            if ((diskCookies = request.getCookies()) != null) {
                for (int i = 0; i < diskCookies.length; ++i) {
                    if (!diskCookies[i].getName().equals(cookieName)) continue;
                    String cookieValue = diskCookies[i].getValue();
                    if (this.securitySSOHandleService == null) {
                        this.securitySSOHandleService = new SecuritySSOHandleServiceImpl();
                    }
                    userAuthDTO = this.securitySSOHandleService.validUser(cookieValue);
                }
            }
        } else {
            Object obj = authentication.getPrincipal();
            if (null != obj && obj instanceof UserAuthDTO) {
                userAuthDTO = (UserAuthDTO)obj;
                userAuthDTO.getAuthorities();
            }
        }
        return userAuthDTO;
    }

    public String getQhjb() {
        String qhdm = AppConfig.getProperty((String)"region.qhdm");
        if (StringUtils.isEmpty((CharSequence)qhdm)) {
            qhdm = this.regionQhdm;
        }
        String qhjb = "";
        if (StringUtils.isNotBlank((CharSequence)qhdm)) {
            XtRegion xtRegion;
            if (this.securitySSOHandleService == null) {
                this.securitySSOHandleService = new SecuritySSOHandleServiceImpl();
            }
            if (null != (xtRegion = this.securitySSOHandleService.getXzqhOne(qhdm))) {
                qhjb = xtRegion.getQhjb();
            }
        }
        return qhjb;
    }

    public String getQhdmByUserAuthDTO(UserAuthDTO userAuthDTO) {
        String qhdm = "";
        if (userAuthDTO != null) {
            Map<String, Object> regionMap = null;
            List<Map<String, Object>> regionList = userAuthDTO.getRegions();
            if (CollectionUtils.isNotEmpty(regionList)) {
                regionMap = regionList.get(0);
            }
            if (regionMap != null) {
                qhdm = CommonUtil.formatEmptyValue((Object)regionMap.get("qhdm"));
            }
        }
        return qhdm;
    }

    public String getQhjbByQhdm(String qhdm) {
        String qhjb = "";
        String szxRegons = AppConfig.getProperty((String)"sjpt.containsSxs.dwdm");
        if (StringUtils.isNotBlank((CharSequence)szxRegons) && szxRegons.contains(qhdm)) {
            qhjb = "";
        } else {
            XtRegion xtRegion = this.securitySSOHandleService.getXzqhOne(qhdm);
            if (null != xtRegion) {
                qhjb = xtRegion.getQhjb();
            }
        }
        return qhjb;
    }

    public List<XtRegion> getXtRegionList(String qhdm, String level) {
        return this.securitySSOHandleService.getLevelXzqh(qhdm, level);
    }
}

