package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.common.Constant;
import cn.gtmap.realestate.supervise.model.GxEncReqData;
import cn.gtmap.realestate.supervise.model.GxEncRespData;
import cn.gtmap.realestate.supervise.model.GxRespData;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

import java.lang.reflect.Method;

/**
 * @author hqz
 * @version 1.0, 2017/7/10
 * @description 访问接口校验AOP
 */
@Aspect
@Order(2)
public class CheckEncTokenAdvice {

    @Pointcut("@annotation(cn.gtmap.realestate.supervise.utils.CheckEncToken)")
    public void anyMethod() {
    }

    @Around("anyMethod()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) {
        Object respObj = null;
        GxEncRespData gxEncRespData = new GxEncRespData();
        Object[] args = pjp.getArgs();//传入的参数
        if (null != args) {
            Object obj = args[0];
            GxEncReqData gxEncReqData = JSON.parseObject(JSON.toJSONString(obj), GxEncReqData.class);
            if (obj != null) {
                String token = gxEncReqData.getToken();
                if (StringUtils.isNotBlank(token)) {
                    TokenPool tokenPool = TokenPoolFactory.getTokenPoolInstance();
                    boolean isValid = tokenPool.validToken(token);
                    if (isValid) {
                        try {
                            respObj = pjp.proceed();
                        } catch (Throwable throwable) {
                            int code = Constant.XTYC;
                            gxEncRespData.setCode(String.valueOf(code));
                            gxEncRespData.setMsg(Constant.getMsg(code));
                            respObj = gxEncRespData;
                        }
                    } else {
                        gxEncRespData.setCode(String.valueOf(Constant.TOKEN));
                        gxEncRespData.setMsg(Constant.getMsg(Constant.TOKEN));
                        respObj = gxEncRespData;
                    }
                }
            }
        }
        return respObj;
    }

    private Method getMethod(JoinPoint joinPoint) {
        Method var8;
        Class<?>[] par = ((MethodSignature) joinPoint.getSignature()).getParameterTypes();

        try {
            var8 = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), par);
        } catch (NoSuchMethodException var6) {
            var6.printStackTrace();
            throw new AppException(var6, 3001);
        }

        return var8;
    }
}
