/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.XssFilterUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class XssAndSqlFormDataWrapper
extends HttpServletRequestWrapper
implements MultipartHttpServletRequest {
    private Map<String, String[]> params = new HashMap<String, String[]>();
    private MultipartHttpServletRequest multReq;

    public XssAndSqlFormDataWrapper(HttpServletRequest request) {
        super(request);
        CommonsMultipartResolver resolver = new CommonsMultipartResolver();
        this.multReq = resolver.resolveMultipart(request);
        this.params.putAll(this.multReq.getParameterMap());
    }

    public Map<String, MultipartFile> getFileMap() {
        return this.multReq.getFileMap();
    }

    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return this.multReq.getMultiFileMap();
    }

    public String getMultipartContentType(String paramOrFileName) {
        return this.multReq.getMultipartContentType(paramOrFileName);
    }

    public Iterator<String> getFileNames() {
        return this.multReq.getFileNames();
    }

    public MultipartFile getFile(String name) {
        return this.multReq.getFile(name);
    }

    public List<MultipartFile> getFiles(String name) {
        return this.multReq.getFiles(name);
    }

    public String[] getParameterValues(String name) {
        if (this.multReq.getFile(name) != null) {
            return null;
        }
        String a = null;
        try {
            a = new String(this.params.get(name)[0].getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new String[]{this.clearXss(a)};
    }

    public Enumeration<String> getParameterNames() {
        HashMap<String, MultipartFile> paramMap = new HashMap<String, MultipartFile>();
        paramMap.putAll(super.getParameterMap());
        paramMap.putAll(this.getFileMap());
        return Collections.enumeration(paramMap.keySet());
    }

    public String getParameter(String name) {
        String[] values = this.params.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public void addParameter(String name, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                this.params.put(name, (String[])value);
            } else if (value instanceof String) {
                this.params.put(name, new String[]{(String)value});
            } else {
                this.params.put(name, new String[]{String.valueOf(value)});
            }
        }
    }

    public BufferedReader getReader() throws IOException {
        return this.multReq.getReader();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.multReq.getInputStream();
    }

    public HttpMethod getRequestMethod() {
        return this.multReq.getRequestMethod();
    }

    public HttpHeaders getRequestHeaders() {
        return this.multReq.getRequestHeaders();
    }

    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        return this.multReq.getMultipartHeaders(paramOrFileName);
    }

    private String clearXss(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return XssFilterUtil.stripXss(value, this.getRequest());
    }

    private static String xssEncode(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("'", "&apos;");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("(?i)<script.*?>.*?<script.*?>", "");
        value = value.replaceAll("(?i)<script.*?>.*?</script.*?>", "");
        value = value.replaceAll("(?i)<.*?javascript:.*?>.*?</.*?>", "");
        value = value.replaceAll("(?i)<.*?\\s+on.*?>.*?</.*?>", "");
        return value;
    }
}

