package cn.gtmap.realestate.supervise.utils;

import java.io.*;

/**
 * @author hqz
 * @version 1.0, 2018/11/19
 * @description 拷贝工具类
 * 此工具类主要是用来做拷贝用的（Map的深拷贝方式，PUTALL方法只能对基础数据类型进行深拷贝，对对象类型只能浅拷贝）
 * 必须序列化的对象才能通过这种方式拷贝
 */
public class CloneUtil {
    public static <T extends Serializable> T clone(T obj){

        T clonedObj = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            clonedObj = (T) ois.readObject();
            ois.close();
        }catch (Exception e){
            e.printStackTrace();
        }
        return clonedObj;
    }
}
