/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import cn.gtmap.realestate.supervise.utils.HttpClientUtil;
import com.gtis.config.AppConfig;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class OperationalLogUtil {
    private static SecuritySSOHandleService securitySSOHandleService = new SecuritySSOHandleServiceImpl();
    private static String URL = AppConfig.getProperty((String)"portal.url") + "/log/save";

    public static void log(HttpServletRequest request, String czlx, String gnmc, String xtmc) {
        HashMap<String, String> paramMap = new HashMap<String, String>(12);
        paramMap.put("czyh", OperationalLogUtil.getCurrentUser(request) == null ? "" : OperationalLogUtil.getCurrentUser(request).getXtUser().getUserName());
        paramMap.put("czlx", czlx);
        paramMap.put("gnmc", gnmc);
        paramMap.put("xtmc", xtmc);
        paramMap.put("ip", OperationalLogUtil.getIpAddr(request));
        try {
            HttpClientUtil.sendHttpClient(URL, paramMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void log(HttpServletRequest request, String czyh, String czlx, String gnmc, String xtmc) {
        HashMap<String, String> paramMap = new HashMap<String, String>(12);
        paramMap.put("czyh", czyh);
        paramMap.put("czlx", czlx);
        paramMap.put("gnmc", gnmc);
        paramMap.put("xtmc", xtmc);
        paramMap.put("ip", OperationalLogUtil.getIpAddr(request));
        try {
            HttpClientUtil.sendHttpClient(URL, paramMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static UserAuthDTO getCurrentUser(HttpServletRequest request) {
        String cookieName = AppConfig.getProperty((String)"platform.cookiename");
        Cookie[] diskCookies = request.getCookies();
        UserAuthDTO userAuthDTO = null;
        if (diskCookies != null) {
            for (int i = 0; i < diskCookies.length; ++i) {
                if (!diskCookies[i].getName().equals(cookieName)) continue;
                String cookieValue = diskCookies[i].getValue();
                userAuthDTO = securitySSOHandleService.validUser(cookieValue);
            }
        }
        return userAuthDTO;
    }
}

