/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.common.Constant;
import cn.gtmap.realestate.supervise.model.GxRespData;
import cn.gtmap.realestate.supervise.utils.CheckToken;
import cn.gtmap.realestate.supervise.utils.TokenPool;
import cn.gtmap.realestate.supervise.utils.TokenPoolFactory;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class CheckTokenAdvice {
    @Pointcut(value="@annotation(cn.gtmap.realestate.supervise.utils.CheckToken)")
    public void anyMethod() {
    }

    @Around(value="anyMethod()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) {
        GxRespData gxRespData = new GxRespData();
        Object object = null;
        Object[] args = pjp.getArgs();
        if (null != args) {
            String gxDataStr = (String)args[0];
            String isAdmin = null;
            if (args.length > 1) {
                isAdmin = (String)args[1];
            }
            if (StringUtils.isNotBlank((CharSequence)gxDataStr)) {
                if (StringUtils.isBlank((CharSequence)isAdmin) || !StringUtils.equals((CharSequence)isAdmin, (CharSequence)"yes")) {
                    Method method = this.getMethod((JoinPoint)pjp);
                    CheckToken auditMethodCheck = method.getAnnotation(CheckToken.class);
                    Class clazz = auditMethodCheck.receiveClass();
                    Object obj = JSONObject.parseObject((String)gxDataStr, (Class)clazz);
                    String token = "";
                    try {
                        Method m1 = clazz.getMethod("getToken", new Class[0]);
                        token = (String)m1.invoke(obj, new Object[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (StringUtils.isNotBlank((CharSequence)token)) {
                        TokenPool tokenPool = TokenPoolFactory.getTokenPoolInstance();
                        boolean isValid = tokenPool.validToken(token);
                        if (isValid) {
                            try {
                                object = pjp.proceed();
                            }
                            catch (Throwable throwable) {
                                int code = 3007;
                                gxRespData.setCode(String.valueOf(code));
                                gxRespData.setMsg(Constant.getMsg(code));
                                object = gxRespData;
                            }
                        } else {
                            gxRespData.setCode(String.valueOf(2002));
                            gxRespData.setMsg(Constant.getMsg(2002));
                            object = gxRespData;
                        }
                    }
                } else {
                    try {
                        object = pjp.proceed();
                    }
                    catch (Throwable throwable) {
                        int code = 3007;
                        gxRespData.setCode(String.valueOf(code));
                        gxRespData.setMsg(Constant.getMsg(code));
                        object = gxRespData;
                    }
                }
            }
        } else {
            gxRespData.setCode(String.valueOf(2002));
            gxRespData.setMsg(Constant.getMsg(2002));
            object = gxRespData;
        }
        return object;
    }

    private Method getMethod(JoinPoint joinPoint) {
        Method var8;
        Class[] par = ((MethodSignature)joinPoint.getSignature()).getParameterTypes();
        try {
            var8 = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), par);
        }
        catch (NoSuchMethodException var6) {
            var6.printStackTrace();
            throw new AppException((Throwable)var6, 3001, new Object[0]);
        }
        return var8;
    }
}

