package cn.gtmap.realestate.supervise.service;

import cn.gtmap.realestate.supervise.entity.BaBwErrorLog;
import cn.gtmap.realestate.supervise.model.FileMessage;

import java.util.List;

/**
 * @author <a href="mailto:liuyaozong@gtmap.cn">liuyaozong</a>
 * @version 1.0, 2024/4/8
 * @description 报文异常处理接口
 */
public interface BwErrorHandleService {

    /**
     * @param baBwErrorLog 报文异常记录表
     * @author <a href="mailto:liuyaozong@gtmap.cn">liuyaozong</a>
     * @description 保存数据至数据库
     */
    void saveBaBwErrorLog(BaBwErrorLog baBwErrorLog);

    /**
     * @param fileMessage 文件消息
     * @param errorMsg    异常信息
     * @param type        类型：0-入库异常 1-上报异常
     * @author <a href="mailto:liuyaozong@gtmap.cn">liuyaozong</a>
     * @description 保存数据至数据库
     */
    void saveBaBwErrorLog(FileMessage fileMessage, String errorMsg, String type);

    /**
     * @param bwid 报文id
     * @param type 类型
     * @return 报文异常记录表集合
     * @author <a href="mailto:liuyaozong@gtmap.cn">liuyaozong</a>
     * @description 根据bwid和类型获取未处理的报文异常记录表集合
     */
    List<BaBwErrorLog> getBaBwErrorLogListByBwid(String bwid, String type);

    /**
     * @param id         主键
     * @param hadHandled 已经处理过
     * @author <a href="mailto:liuyaozong@gtmap.cn">liuyaozong</a>
     * @description 更新报文异常记录表的处理状态
     */
    void updateBaBwErrorLogHadHandled(String id, String hadHandled);

    /**
     * @param type 类型
     * @param dwdm 单位代码
     * @return 报文异常记录表集合
     * @author <a href="mailto:liuyaozong@gtmap.cn">liuyaozong</a>
     * @description 根据类型和单位代码获取未处理的报文异常记录表集合
     */
    List<BaBwErrorLog> getBaBwErrorLogListByType(String type, String dwdm);

}
