package cn.gtmap.realestate.supervise.utils;

import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;

/**
 * Created by Administrator on 2018/3/8.
 */
public class JedisPoolUtil {

    //私有构造方法
    private JedisPoolUtil() {
    }

    //保证内存中只有一个连接池对象
    public static JedisPool pool = null;


    //静态代码块
    static {
        String redisIp = AppConfig.getProperty("exchange.redis.ip");
        String redisPort =AppConfig.getProperty("exchange.redis.port");
        //读取相应的值
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMinIdle(10);//最小空闲连接数minIdle
        config.setMaxIdle(50);//最大空闲连接数maxIdle
        config.setMaxTotal(1000);//最大连接数maxTotal
        config.setMaxWaitMillis(10000);//最大等待超时时间maxWaitMillis
        //在borrow一个jedis实例时，是否提前进行validate操作；如果为true，则得到的jedis实例均是可用的；
        config.setTestOnBorrow(true);

        //是否密码登录redis
        boolean checkPwd = false;
        String authPassword = AppConfig.getProperty("exchange.redis.password");
        if (StringUtils.isNotBlank(authPassword)) {
            checkPwd = true;
            authPassword = AESSecutiryUtil.decrypt(authPassword);
        }

        if (checkPwd) {
            pool = new JedisPool(config, redisIp, Integer.parseInt(redisPort), Protocol.DEFAULT_TIMEOUT, authPassword);
        } else {
            pool = new JedisPool(config, redisIp, Integer.parseInt(redisPort));
        }

    }

    //获取连接
    public static Jedis getJedis() {
        return pool.getResource();
    }

    //关闭连接
    public static void closeJedis(Jedis jedis) {
        jedis.close();
    }


}
