package cn.gtmap.realestate.supervise.entity;

import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 操作日志表
 */
@Table(name = "xt_cz_log")
public class XtCzLog {
    //下载
    @Transient
    public final static String CZLX_XZ = "1";
    //上传
    @Transient
    public final static String CZLX_UP = "2";
    //资源调用
    @Transient
    public final static String CZLX_ZYDY = "0";
    //系统登录
    @Transient
    public final static String CZLX_XTDL = "3";
    //系统操作
    @Transient
    public final static String CZLX_XTCZ = "8";
    //无权访问
    @Transient
    public final static String CZLX_WQFW = "9";
    //增加
    @Transient
    public final static String CZLX_ZJ = "4";
    //删除
    @Transient
    public final static String CZLX_DEL = "5";
    //修改
    @Transient
    public final static String CZLX_XG = "6";

    /**
     * id
     */
    @Id
    private String id;

    /**
     * 操作用户
     */
    private String czyh;

    /**
     * 操作时间
     */
    private Date czsj;

    /**
     * 操作类型
     */
    private String czlx;

    /**
     * 功能名称
     */
    private String gnmc;

    /**
     * 系统名称
     */
    private String xtmc;

    /**
     * IP地址
     */
    private String ip;

    public XtCzLog() {}

    public XtCzLog(String id, String czyh, Date czsj, String czlx, String gnmc, String xtmc, String ip) {
        this.id = id;
        this.czyh = czyh;
        this.czsj = czsj;
        this.czlx = czlx;
        this.gnmc = gnmc;
        this.xtmc = xtmc;
        this.ip = ip;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCzyh() {
        return czyh;
    }

    public void setCzyh(String czyh) {
        this.czyh = czyh;
    }

    public Date getCzsj() {
        return czsj;
    }

    public void setCzsj(Date czsj) {
        this.czsj = czsj;
    }

    public String getCzlx() {
        return czlx;
    }

    public void setCzlx(String czlx) {
        this.czlx = czlx;
    }

    public String getGnmc() {
        return gnmc;
    }

    public void setGnmc(String gnmc) {
        this.gnmc = gnmc;
    }

    public String getXtmc() {
        return xtmc;
    }

    public void setXtmc(String xtmc) {
        this.xtmc = xtmc;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCzsjDate(){
        if(null != czsj){
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sf.format(czsj);
        }
        return "";
    }

    @Override
    public String toString() {
        return "XtCzLog{" +
            "id='" + id + '\'' +
            ", czyh='" + czyh + '\'' +
            ", czsj=" + czsj +
            ", czlx='" + czlx + '\'' +
            ", gnmc='" + gnmc + '\'' +
            ", xtmc='" + xtmc + '\'' +
            ", ip='" + ip + '\'' +
            '}';
    }
}
