/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.common.Constant;
import cn.gtmap.realestate.supervise.model.GxEncReqData;
import cn.gtmap.realestate.supervise.model.GxEncRespData;
import cn.gtmap.realestate.supervise.utils.TokenPool;
import cn.gtmap.realestate.supervise.utils.TokenPoolFactory;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=2)
public class CheckEncTokenAdvice {
    @Pointcut(value="@annotation(cn.gtmap.realestate.supervise.utils.CheckEncToken)")
    public void anyMethod() {
    }

    @Around(value="anyMethod()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) {
        Object respObj = null;
        GxEncRespData gxEncRespData = new GxEncRespData();
        Object[] args = pjp.getArgs();
        if (null != args) {
            String token;
            Object obj = args[0];
            GxEncReqData gxEncReqData = (GxEncReqData)JSON.parseObject((String)JSON.toJSONString((Object)obj), GxEncReqData.class);
            if (obj != null && StringUtils.isNotBlank((CharSequence)(token = gxEncReqData.getToken()))) {
                TokenPool tokenPool = TokenPoolFactory.getTokenPoolInstance();
                boolean isValid = tokenPool.validToken(token);
                if (isValid) {
                    try {
                        respObj = pjp.proceed();
                    }
                    catch (Throwable throwable) {
                        int code = 3007;
                        gxEncRespData.setCode(String.valueOf(code));
                        gxEncRespData.setMsg(Constant.getMsg(code));
                        respObj = gxEncRespData;
                    }
                } else {
                    gxEncRespData.setCode(String.valueOf(2002));
                    gxEncRespData.setMsg(Constant.getMsg(2002));
                    respObj = gxEncRespData;
                }
            }
        }
        return respObj;
    }

    private Method getMethod(JoinPoint joinPoint) {
        Method var8;
        Class[] par = ((MethodSignature)joinPoint.getSignature()).getParameterTypes();
        try {
            var8 = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), par);
        }
        catch (NoSuchMethodException var6) {
            var6.printStackTrace();
            throw new AppException((Throwable)var6, 3001, new Object[0]);
        }
        return var8;
    }
}

