/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.AESEncrypter;
import cn.gtmap.realestate.supervise.utils.JedisPoolUtil;
import cn.gtmap.realestate.supervise.utils.TimeUtils;
import cn.gtmap.realestate.supervise.utils.TokenPool;
import com.gtis.config.AppConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class YzmTokenPool {
    private static YzmTokenPool yzmTokenPool = null;
    private List<TokenEntry> yzmTokenPools = new ArrayList<TokenEntry>();
    private static final String publickey = "gtmap_wechat";
    private static final String validMinute = AppConfig.getProperty((String)"valid.Minute") == null ? "5" : AppConfig.getProperty((String)"valid.Minute");
    private static final String REDIS_TOKEN = "TOKEN";
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenPool.class);

    private YzmTokenPool() {
    }

    public static YzmTokenPool getTokenPoolInstance() {
        if (null == yzmTokenPool) {
            yzmTokenPool = new YzmTokenPool();
        }
        return yzmTokenPool;
    }

    public synchronized String getToken(String key) {
        String token = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            token = this.validUserHasToken(key);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                return token;
            }
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
            String strNow = sf.format(now);
            String content = key + "|" + strNow;
            byte[] bytes = AESEncrypter.encrypt(content, publickey);
            token = YzmTokenPool.byteArrayToHexStr(bytes);
            Jedis jedis = JedisPoolUtil.getJedis();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("token_" + key, token);
            map.put("time_" + key, strNow);
            map.put("userId_" + key, key);
            jedis.hmset(REDIS_TOKEN, map);
            jedis.close();
        }
        return token;
    }

    public synchronized boolean validToken(String token) {
        boolean isflag = false;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            Jedis jedis = JedisPoolUtil.getJedis();
            Map maps = jedis.hgetAll(REDIS_TOKEN);
            if (maps.containsValue(token)) {
                String tokenKey = "";
                String timeKey = "";
                String userIdKey = "";
                for (Map.Entry entry : maps.entrySet()) {
                    if (!token.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)tokenKey)) continue;
                    tokenKey = (String)entry.getKey();
                    break;
                }
                timeKey = tokenKey.replace("token", "time");
                userIdKey = tokenKey.replace("token", "userId");
                String time = YzmTokenPool.formatTime(timeKey);
                Date oldDate = TimeUtils.strToDateTime(time);
                boolean isValid = this.validDate(oldDate);
                if (!isValid) {
                    jedis.hdel(REDIS_TOKEN, new String[]{userIdKey, timeKey, tokenKey});
                }
                isflag = isValid;
            }
            jedis.close();
        }
        return isflag;
    }

    private boolean validDate(Date initDate) {
        int min = 5;
        if (StringUtils.isNotBlank((CharSequence)validMinute)) {
            min = Integer.parseInt(validMinute);
        }
        Calendar cd = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        cd.setTime(initDate);
        cd.add(12, min);
        return now.before(cd);
    }

    public String validUserHasToken(String key) {
        String token = null;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            String time;
            Jedis jedis = JedisPoolUtil.getJedis();
            String userIdKey = "userId_" + key;
            String timeKey = "time_" + key;
            String tokenKey = "token_" + key;
            String userIdStr = jedis.hget(REDIS_TOKEN, userIdKey);
            if (StringUtils.isNotEmpty((CharSequence)userIdStr) && StringUtils.equals((CharSequence)key, (CharSequence)userIdStr) && StringUtils.isNotEmpty((CharSequence)(time = jedis.hget(REDIS_TOKEN, timeKey)))) {
                Date oldDate = TimeUtils.strToDateTime(time);
                boolean isValid = this.validDate(oldDate);
                if (isValid) {
                    token = jedis.hget(REDIS_TOKEN, tokenKey);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(timeKey, TimeUtils.dateToStr(new Date(System.currentTimeMillis())));
                    jedis.hmset(REDIS_TOKEN, map);
                } else {
                    jedis.hdel(REDIS_TOKEN, new String[]{userIdKey, timeKey, tokenKey});
                }
            }
            jedis.close();
        }
        return token;
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUsernameByToken(String token) {
        String username = "";
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try (Jedis jedis = JedisPoolUtil.getJedis();){
                Map maps = jedis.hgetAll(REDIS_TOKEN);
                if (maps.containsValue(token)) {
                    String tokenKey = "";
                    for (Map.Entry entry : maps.entrySet()) {
                        if (!token.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)tokenKey)) continue;
                        tokenKey = (String)entry.getKey();
                        break;
                    }
                    if (StringUtils.isNotBlank((CharSequence)tokenKey)) {
                        username = tokenKey.replace("token_", "");
                    }
                }
            }
        }
        return username;
    }

    public static String formatTime(String time) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{time})) {
            return time.split("_")[1].substring(0, 13);
        }
        return null;
    }

    public class TokenEntry {
        String token;
        Date initDate;
        String initUser;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public Date getInitDate() {
            return this.initDate;
        }

        public void setInitDate(Date initDate) {
            this.initDate = initDate;
        }

        public String getInitUser() {
            return this.initUser;
        }

        public void setInitUser(String initUser) {
            this.initUser = initUser;
        }
    }
}

