/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.rsa;

import cn.gtmap.realestate.supervise.utils.FileUtil;
import com.inspur.uaccess.common.exception.NoMatchXMLDocumentException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.security.utils.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class RSASignature {
    private static final String KEY_ALGORTHM = "RSA";
    private static final String SIGNATURE = "SHA1WithRSA";
    static String signature1;

    public static void main(String[] args) throws IOException, NullPointerException, DocumentException, NoMatchXMLDocumentException {
        String public_key = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDT9TsOfGqhv+3TxeU/jNwskOlXPF35Gffm4oGjUyC2ajplEiRZ+57x5wYXtqh1B3ulnSQY1PLO/Pw8i0jg1uwQoO0izGk31CrIloFpKAcve5JfGx0XBK1cffsGpFvjzL/gvRZHHvqGOH1BOyST8EcOrDnuT3Y3FtYbGdeDlH6AGQIDAQAB";
        String xmlString = new String(FileUtil.getBytes(new File("D:\\Biz320684170518003593.xml")), "UTF-8");
        try {
            System.out.println(RSASignature.CheckXmlByPulKey(xmlString, public_key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getNewMsgWithSignature(String oldMsg, String key) throws DocumentException, NoMatchXMLDocumentException, NullPointerException {
        if (oldMsg == null || key == null || "".equals(oldMsg) || "".equals(key)) {
            throw new NullPointerException("\u6d88\u606f\u6e90\u3001\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        String msgId = RSASignature.getTextByXpath("/Message/Head/BizMsgID", oldMsg);
        String msg = oldMsg.replaceFirst("<BizMsgID>[\\s\\S]*</BizMsgID>", "<BizMsgID></BizMsgID>");
        signature1 = RSASignature.getSignature(msg, key);
        String newMsg = msg.replaceFirst("<BizMsgID></BizMsgID>", "<BizMsgID>" + msgId + "</BizMsgID>\r\n" + "<DigitalSign>" + signature1 + "</DigitalSign>");
        return newMsg;
    }

    private static String getTextByXpath(String xpath, String xml) throws DocumentException, NoMatchXMLDocumentException {
        Document document = DocumentHelper.parseText((String)xml);
        Node destNode = document.selectSingleNode(xpath);
        if (destNode == null) {
            throw new NoMatchXMLDocumentException("XML\u6587\u6863\u4e2d\u627e\u4e0d\u5230\u5339\u914d\u7684\u8def\u5f84/Message/Head/BizMsgID,\u65e0\u6cd5\u89e3\u6790\u6587\u6863.");
        }
        return destNode.getText();
    }

    public static String getSignature(String msg, String key) {
        return RSASignature.byte2hex(RSASignature.getSignature(RSASignature.getKeyBytes(msg), key));
    }

    public static byte[] getKeyBytes(String msg) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(msg.getBytes("UTF-8"));
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static byte[] getSignature(byte[] summary, String privateKey) {
        try {
            byte[] keyBytes = RSASignature.str2BASE64(privateKey);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORTHM);
            PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signature = Signature.getInstance(SIGNATURE);
            signature.initSign(privateK);
            signature.update(summary);
            byte[] signed = signature.sign();
            return signed;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String byte2hex(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            throw new IllegalArgumentException("this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toLowerCase();
    }

    private static byte[] str2BASE64(String key) throws Exception {
        return Base64.decode((String)key);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (StringUtils.isEmpty((CharSequence)hexString)) {
            return new byte[0];
        }
        hexString = hexString.toLowerCase();
        byte[] byteArray = new byte[hexString.length() / 2];
        int k = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte high = (byte)(Character.digit(hexString.charAt(k), 16) & 0xFF);
            byte low = (byte)(Character.digit(hexString.charAt(k + 1), 16) & 0xFF);
            byteArray[i] = (byte)(high << 4 | low);
            k += 2;
        }
        return byteArray;
    }

    public static boolean CheckXmlByPulKey(String xmlContent, String publicKey) {
        try {
            String signature = RSASignature.getTextByXpath("/Message/Head/DigitalSign", xmlContent);
            String msg = xmlContent.replaceFirst("<BizMsgID>[\\s\\S]*</DigitalSign>", "<BizMsgID></BizMsgID>");
            return RSASignature.verify(RSASignature.getKeyBytes(msg), publicKey, RSASignature.hexStringToBytes(signature));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean verify(byte[] data, String publicKey, byte[] sign) throws Exception {
        byte[] keyBytes = RSASignature.str2BASE64(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORTHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(sign);
    }
}

