/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.service;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import cn.gtmap.realestate.supervise.utils.AESSecutiryUtil;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.gtis.config.AppConfig;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class SecurityUrlCheckFilter
implements Filter {
    private String excludedPages;
    private String[] excludedPageArray;
    private String includedPages;
    private String[] includedPageArray;
    private SecuritySSOHandleService securitySSOHandleService = new SecuritySSOHandleServiceImpl();
    private String SSOLoginPage = AppConfig.getProperty((String)"portal.url") + "/loginPage";
    private String noPermissionPage = AppConfig.getProperty((String)"portal.url") + "/401";
    private String otherPortalUrl = AppConfig.getProperty((String)"other.portal.url");

    public void init(FilterConfig filterConfig) throws ServletException {
        int i;
        this.excludedPages = filterConfig.getInitParameter("excludedPages");
        if (StringUtils.isNotEmpty((CharSequence)this.excludedPages)) {
            this.excludedPageArray = this.excludedPages.split(",");
        }
        if (this.excludedPageArray != null && this.excludedPageArray.length != 0) {
            for (i = 0; i < this.excludedPageArray.length; ++i) {
                this.excludedPageArray[i] = StringUtils.trim((String)this.excludedPageArray[i]);
            }
        }
        this.includedPages = filterConfig.getInitParameter("includedPages");
        if (StringUtils.isNotEmpty((CharSequence)this.includedPages)) {
            this.includedPageArray = this.includedPages.split(",");
        }
        if (this.includedPageArray != null && this.includedPageArray.length != 0) {
            for (i = 0; i < this.includedPageArray.length; ++i) {
                this.includedPageArray[i] = StringUtils.trim((String)this.includedPageArray[i]);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String url = httpRequest.getServletPath();
        String groupName = StringUtils.substring((String)httpRequest.getContextPath(), (int)1);
        boolean isExcludedPage = false;
        if (this.includedPageArray != null && this.includedPageArray.length > 0) {
            isExcludedPage = true;
            for (String page : this.includedPageArray) {
                if (!this.validUrl(url, page)) continue;
                isExcludedPage = false;
                break;
            }
        }
        if (this.excludedPageArray != null && this.excludedPageArray.length > 0) {
            for (String page : this.excludedPageArray) {
                if (!this.validUrl(url, page)) continue;
                isExcludedPage = true;
                break;
            }
        }
        if (isExcludedPage) {
            chain.doFilter(request, response);
        } else {
            String cookieName = AppConfig.getProperty((String)"platform.cookiename");
            Cookie[] diskCookies = httpRequest.getCookies();
            boolean flag = false;
            if (diskCookies != null) {
                for (int i = 0; i < diskCookies.length; ++i) {
                    if (!diskCookies[i].getName().equals(cookieName)) continue;
                    String cookieValue = diskCookies[i].getValue();
                    String ip = IpUtil.getIpAddr(httpRequest);
                    String[] cookieValues = cookieValue.split("ip");
                    if (cookieValues.length == 2 && StringUtils.equals((CharSequence)ip, (CharSequence)AESSecutiryUtil.decrypt(cookieValues[1]))) {
                        UserAuthDTO userAuthDTO = this.securitySSOHandleService.validUser(cookieValue);
                        if (null == userAuthDTO) {
                            if (StringUtils.isNotBlank((CharSequence)this.otherPortalUrl)) {
                                httpResponse.sendRedirect(this.otherPortalUrl);
                            } else {
                                httpResponse.sendRedirect(this.SSOLoginPage);
                            }
                        } else {
                            boolean isValid = this.securitySSOHandleService.validResource(url, cookieValue, groupName);
                            if (isValid) {
                                chain.doFilter(request, response);
                            } else {
                                OperationalLogUtil.log(httpRequest, "9", "\u65e0\u6743\u8bbf\u95ee:" + url, "\u57fa\u7840\u652f\u6491\u5e73\u53f0");
                                httpResponse.sendRedirect(this.noPermissionPage);
                            }
                        }
                    }
                    flag = true;
                }
            }
            if (!flag) {
                httpResponse.sendRedirect(this.SSOLoginPage);
            }
        }
    }

    private boolean validUrl(String url, String excludedPage) {
        if (excludedPage.endsWith("/*") || excludedPage.endsWith("/**")) {
            excludedPage = excludedPage.replace("*", "");
        }
        return url.startsWith(excludedPage) || StringUtils.equals((CharSequence)url, (CharSequence)excludedPage.substring(0, excludedPage.length() - 1));
    }

    public void destroy() {
    }
}

