/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.aes;

import cn.gtmap.realestate.supervise.aes.SecurityUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class AESUtil
extends SecurityUtil {
    public static byte[] getRawKey(String key) {
        return AESUtil.getRawKey(key.getBytes());
    }

    @Override
    public byte[] getDecrKey() {
        return AESUtil.getRawKey("gtmap");
    }

    @Override
    public byte[] getEncrKey() {
        return AESUtil.getRawKey("gtmap");
    }

    @Override
    public String decrypt(String encrypted) {
        try {
            byte[] bytes = AESUtil.hexStringToBytes(encrypted);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.getDecrKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            byte[] decrypted = cipher.doFinal(bytes);
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String decryptNotUtf8(String encrypted) {
        try {
            byte[] bytes = AESUtil.hexStringToBytes(encrypted);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.getDecrKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            byte[] decrypted = cipher.doFinal(bytes);
            return new String(decrypted);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String decryptXML(String encrypted) {
        try {
            byte[] bytes = AESUtil.hexStringToBytes(encrypted);
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.getDecrKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            byte[] decrypted = cipher.doFinal(bytes);
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String encrypt(String clearPwd) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.getEncrKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            if (null != clearPwd && !clearPwd.isEmpty()) {
                byte[] encypted = cipher.doFinal(clearPwd.getBytes("UTF-8"));
                return AESUtil.byte2hex(encypted);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String encryptXml(String clearPwd) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.getEncrKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            if (null != clearPwd && !clearPwd.isEmpty()) {
                byte[] encypted = cipher.doFinal(clearPwd.getBytes("UTF-8"));
                return AESUtil.byte2hex(encypted);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] getRawKey(byte[] seed) {
        byte[] rawKey = null;
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(seed);
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            rawKey = secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return rawKey;
    }

    public static String byte2hex(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1) {
            throw new IllegalArgumentException("this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16) {
                hexString.append("0");
            }
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toLowerCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(AESUtil.charToByte(hexChars[pos]) << 4 | AESUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

