package cn.gtmap.realestate.supervise.utils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Scanner;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/6/16
 * @description 加密具体实现的方法，这个方法是采用网上提供的AES加密，可以继承Security实现自己的加密方法
 * Security是模板方法尽量不要修改，如需修改请注意每个方法的作用
 */

public class AESSecutiryUtil {

    /**
     * 字符串逗号分隔符
     */
    public static final String SPLIT_STR_COMMA = ",";

    public static byte[] getRawKey(String key) {
        return getRawKey(key.getBytes());
    }


    public static byte[] getDecrKey() {
        return getRawKey("gtmap");
    }

    public static byte[] getEncrKey() {
        return getRawKey("gtmap");
    }


    /**
     * 解密
     *
     * @param encrypted
     * @return
     */
    public static String decrypt(String encrypted) {
        try {
            byte[] bytes = hexStringToBytes(encrypted);
            SecretKeySpec secretKeySpec = new SecretKeySpec(getDecrKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
            byte[] decrypted = cipher.doFinal(bytes);
            String res = new String(decrypted, "UTF-8");
            return res;
        } catch (Exception e) {
            return "";
        }
    }


    public static String encrypt(String clearPwd) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(getEncrKey(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec);
            byte[] encypted = cipher.doFinal(clearPwd.getBytes("UTF-8"));
            return byte2hex(encypted);
        } catch (Exception e) {
            return null;
        }
    }


    /**
     * 解密  解密失败返回原文
     *
     * @param encrypted
     * @return
     */
    public static String decryptYw(String encrypted) {
        StringBuilder ret_encrypted = new StringBuilder("");
        try {
            if (StringUtils.isNotBlank(encrypted)) {
                String[] encryptedArr = org.apache.commons.lang.StringUtils.split(encrypted, SPLIT_STR_COMMA);
                if (encryptedArr.length > 0) {
                    for (String encryptedTemp : encryptedArr) {
                        byte[] bytes = hexStringToBytes(encryptedTemp);
                        SecretKeySpec secretKeySpec = new SecretKeySpec(getDecrKey(), "AES");
                        Cipher cipher = Cipher.getInstance("AES");
                        cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);
                        byte[] decrypted = cipher.doFinal(bytes);
                        String res = new String(decrypted, "UTF-8");
                        if (StringUtils.isNotBlank(ret_encrypted)) {
                            ret_encrypted = ret_encrypted.append(SPLIT_STR_COMMA).append(res);
                        } else {
                            ret_encrypted = ret_encrypted.append(res);
                        }
                    }
                }
            }
            //  return res;
        } catch (Exception e) {
            return encrypted;
        }

        if (StringUtils.isNotBlank(ret_encrypted.toString())) {
            return ret_encrypted.toString();
        }
        return "/";
    }


    public static byte[] getRawKey(byte[] seed) {
        byte[] rawKey = null;
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(seed);
            // AES加密数据块分组长度必须为128比特，密钥长度可以是128比特、192比特、256比特中的任意一个
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            rawKey = secretKey.getEncoded();
        } catch (NoSuchAlgorithmException e) {
        }
        return rawKey;
    }

    private static String byte2hex(byte[] byteArray) {
        if ((byteArray == null) || (byteArray.length < 1)) {
            throw new IllegalArgumentException(
                    "this byteArray must not be null or empty");
        }
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            if ((byteArray[i] & 0xFF) < 16)
                hexString.append("0");
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }

        return hexString.toString().toLowerCase();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; i++) {
            int pos = i * 2;
            d[i] = (byte) (charToByte(hexChars[pos]) << 4 | charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte) "0123456789ABCDEF".indexOf(c);
    }

    public static void main(String[] args) {
        while (true) {
            System.out.print("请输入1、2（1-用户密码加密；2-数据库配置文件密码加密；）：");
            Scanner scan = new Scanner(System.in);
            String read = scan.nextLine();
            if (StringUtils.equals("1", read)) {
                System.out.print("请输入用户密码：");
                scan = new Scanner(System.in);
                read = scan.nextLine();
                Md5PasswordEncoder md5PasswordEncoder = new Md5PasswordEncoder();
                String md5Pwd = md5PasswordEncoder.encodePassword(read, null);
                System.out.println("加密之后：" + md5Pwd);
            } else {
                System.out.print("请输入数据库配置文件密码：");
                scan = new Scanner(System.in);
                read = scan.nextLine();
                System.out.println("加密之后：" + AESSecutiryUtil.encrypt(read));
            }
        }
    }
}
