/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.XssAndSqlHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class XssAndSqlFilter
implements Filter {
    private String excludedPages;
    private String[] excludedPageArray;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String url = httpRequest.getServletPath();
        boolean isExcludedPage = false;
        if (null != this.excludedPageArray) {
            for (String page : this.excludedPageArray) {
                if (!this.validUrl(url, page)) continue;
                isExcludedPage = true;
                break;
            }
        }
        if (isExcludedPage) {
            chain.doFilter(request, response);
        } else {
            XssAndSqlHttpServletRequestWrapper xssRequest = new XssAndSqlHttpServletRequestWrapper((HttpServletRequest)request);
            chain.doFilter((ServletRequest)xssRequest, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.excludedPages = filterConfig.getInitParameter("excludedPages");
        if (StringUtils.isNotEmpty((CharSequence)this.excludedPages)) {
            this.excludedPageArray = this.excludedPages.split(",");
        }
        if (null != this.excludedPageArray && this.excludedPageArray.length != 0) {
            for (int i = 0; i < this.excludedPageArray.length; ++i) {
                this.excludedPageArray[i] = StringUtils.trim((String)this.excludedPageArray[i]);
            }
        }
    }

    private boolean validUrl(String url, String excludedPage) {
        if (excludedPage.endsWith("/*") || excludedPage.endsWith("/**")) {
            excludedPage = excludedPage.replace("*", "");
        }
        return url.startsWith(excludedPage) || StringUtils.equals((CharSequence)url, (CharSequence)excludedPage.substring(0, excludedPage.length() - 1));
    }
}

