/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.model.yw_encrypt;

import com.jmj.FMException;
import com.jmj.FmBaseApi;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YwApi {
    private static final Logger logger = LoggerFactory.getLogger(YwApi.class);
    private static final int SM4_ENCRYPT_MODEL = 1;
    private static final int SM4_DECRYPT_MODEL = 2;
    private static FmBaseApi fmapi;
    private static String password;
    private static int KEY_NUM;
    private static int FME_OK;
    public static final String prefix = "pamtgms";

    public static void getConnect() {
        if (null == fmapi) {
            fmapi = FmBaseApi.getInstance();
        }
        try {
            fmapi.FM_CPC_OpenDevice(password.getBytes());
        }
        catch (FMException e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        if (null == fmapi) {
            fmapi = FmBaseApi.getInstance();
        }
        fmapi.FM_CPC_CloseDevice();
    }

    public static String sm4EncryptHexStr(String sm4Indata) {
        block3: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)sm4Indata) || sm4Indata.startsWith(prefix)) break block3;
                byte[] inData = YwApi.padding(sm4Indata.getBytes("UTF-8"), 1);
                byte[] endata = new byte[1024];
                int[] oulen = new int[1];
                int rv = fmapi.FM_CPC_Encrypt(KEY_NUM, 8, 0, inData, inData.length, endata, oulen, null, 0, null, 0);
                if (rv != FME_OK) {
                    logger.error(sm4Indata + "SM4\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_Encrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block3;
                }
                return prefix + Hex.encodeHexString((byte[])endata);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sm4Indata;
    }

    public static String sm4DecryptHexStr(String sm4HexData) {
        block4: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)sm4HexData) || !sm4HexData.startsWith(prefix)) break block4;
                byte[] inData = YwApi.padding(Hex.decodeHex((char[])sm4HexData.substring(prefix.length()).toCharArray()), 2);
                byte[] outdata = new byte[1024];
                int[] oulen = new int[1];
                int rv = fmapi.FM_CPC_Decrypt(KEY_NUM, 8, 0, inData, inData.length, outdata, oulen, null, 0, null, 0);
                if (rv != FME_OK) {
                    logger.error(sm4HexData + "SM4\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_Decrypt \u89e3\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block4;
                }
                return new String(outdata, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (DecoderException e) {
                e.printStackTrace();
            }
        }
        return sm4HexData;
    }

    public static String sm2EncryptHexStr(String sm2Indata) {
        block3: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)sm2Indata)) break block3;
                byte[] inData = sm2Indata.getBytes("UTF-8");
                byte[] encData = new byte[260];
                int rv = fmapi.FM_CPC_ECCEncrypt(3, KEY_NUM, inData, inData.length, null, encData);
                if (rv != FME_OK) {
                    logger.error(sm2Indata + "SM2\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_ECCEncrypt \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block3;
                }
                return Hex.encodeHexString((byte[])encData);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sm2Indata;
    }

    public static String sm2DecryptHexStr(String sm2Hexdata) {
        block4: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)sm2Hexdata)) break block4;
                byte[] inData = Hex.decodeHex((char[])sm2Hexdata.toCharArray());
                byte[] outData = new byte[32];
                int[] outlen = new int[1];
                int rv = fmapi.FM_CPC_ECCDecrypt(3, KEY_NUM, inData, null, outData, outlen);
                if (rv != FME_OK) {
                    logger.error(sm2Hexdata + "SM2\u89e3\u5bc6\u5931\u8d25\uff01 FM_CPC_ECCDecrypt \u89e3\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block4;
                }
                return new String(outData, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (DecoderException e) {
                e.printStackTrace();
            }
        }
        return sm2Hexdata;
    }

    public static String sm3HashHexStr(String sm3Indata) {
        block3: {
            try {
                if (!StringUtils.isNotBlank((CharSequence)sm3Indata)) break block3;
                byte[] inData = sm3Indata.getBytes("UTF-8");
                byte[] outdata = new byte[128];
                int[] outlen = new int[]{128};
                fmapi.FM_CPC_SM3Init(null, null, 0);
                fmapi.FM_CPC_SM3Update(inData, inData.length);
                int rv = fmapi.FM_CPC_SM3Final(outdata, outlen);
                if (rv != FME_OK) {
                    logger.error(sm3Indata + "SM3\u52a0\u5bc6\u5931\u8d25\uff01 FM_CPC_SM3Final \u52a0\u5bc6\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block3;
                }
                return Hex.encodeHexString((byte[])outdata);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sm3Indata;
    }

    public static String sm2Sign(String sm2SignData) {
        block3: {
            try {
                byte[] signData;
                if (!StringUtils.isNotBlank((CharSequence)sm2SignData)) break block3;
                byte[] inData = sm2SignData.getBytes("UTF-8");
                int rv = fmapi.FM_CPC_ECCSign(KEY_NUM, inData, inData.length, null, signData = new byte[64]);
                if (rv != FME_OK) {
                    logger.error(sm2SignData + "SM2\u7b7e\u540d\u5931\u8d25\uff01 FM_CPC_ECCSign \u7b7e\u540d\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block3;
                }
                return Hex.encodeHexString((byte[])signData);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sm2SignData;
    }

    public static boolean sm2VerifySign(String sm2InData, String sm2SignData) {
        block3: {
            try {
                byte[] signData;
                if (!StringUtils.isNotBlank((CharSequence)sm2InData) || !StringUtils.isNotBlank((CharSequence)sm2SignData)) break block3;
                byte[] inData = sm2InData.getBytes("UTF-8");
                int rv = fmapi.FM_CPC_ECCVerify(KEY_NUM, null, inData, inData.length, signData = sm2SignData.getBytes("UTF-8"));
                if (rv != FME_OK) {
                    logger.error(sm2InData + "SM2\u9a8c\u7b7e\u5931\u8d25\uff01 FM_CPC_ECCVerify \u9a8c\u7b7e\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + rv);
                    break block3;
                }
                return true;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static byte[] padding(byte[] input, int mode) {
        if (input == null) {
            return null;
        }
        if (mode == 1) {
            int p = 16 - input.length % 16;
            byte[] ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            ret[input.length + p - 1] = (byte)p;
            return ret;
        }
        if (mode == 2) {
            byte p = input[input.length - 1];
            byte[] ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
            return ret;
        }
        return input;
    }

    static {
        password = "12345678";
        KEY_NUM = 1;
        FME_OK = 0;
    }
}

