package cn.gtmap.realestate.supervise.common;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtUser;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
/**
 * @author hqz
 * @version 1.0, 2017/6/14
 * @description 用户信息初始化类
 */
@Controller
public class BaseController extends  BaseInfoController{


    @ModelAttribute
    public void initRequset(Model model){
        HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        UserAuthDTO userAuthDTO = getCurrentUser(req);
        if (null != userAuthDTO) {
            XtUser xtUser = userAuthDTO.getXtUser();
            model.addAttribute("currUser", xtUser.getUserName());
            if(null != xtUser){
                String userid = xtUser.getUserId();
                model.addAttribute("currLogin",xtUser.getLoginName());
                model.addAttribute("users",userAuthDTO);
                model.addAttribute("currUserRegion",getCurrRegionLst(userid));
                model.addAttribute("currUserGroup",getCurrGroupLst(userid));
                model.addAttribute("isAdmin",userAuthDTO.getIsAdmin().toString());
            }else{
                model.addAttribute("currUserRegion","   ");
            }
        }
    }

}
