package cn.gtmap.realestate.supervise.utils;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.rpc.client.RPCServiceClient;
import org.apache.axis2.transport.http.HTTPConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.namespace.QName;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/11/20
 * @description webService访问工具类
 */
public class WebServiceUtil {

    private final static Logger logger = LoggerFactory.getLogger(WebServiceUtil.class);

    //解决tomcat temp文件夹每次请求生成临时文件
    private static ConfigurationContext configurationContext;


    public static String sendRequest(String url, String nameSpace, String methodName, Map<String, String> params) {

        //使用RPC方式调用WebService
        RPCServiceClient serviceClient = null;
        String res = "";
        try {
            serviceClient = new RPCServiceClient(configurationContext, null);
            Options options = serviceClient.getOptions();

//            options.exchange.connect.time(1000 * 60 * 3);//
//            options.setTimeOutInMilliSeconds(1000 * 60 * 2);
            EndpointReference targetEPR = new EndpointReference(url);
            options.setTo(targetEPR);
            options.setExceptionToBeThrownOnSOAPFault(false);

            options.setManageSession(true);//解决Unable to sendViaPost to url Timeout waiting for connection
            options.setProperty(HTTPConstants.REUSE_HTTP_CLIENT,true);//解决Unable to sendViaPost to url Timeout waiting for connection
            options.setProperty(HTTPConstants.SO_TIMEOUT, 120000);

            OMFactory fac = OMAbstractFactory.getOMFactory();

            // 这个和qname差不多，设置命名空间
            OMNamespace omNs = fac.createOMNamespace(nameSpace, methodName);

            OMElement data = fac.createOMElement(methodName, omNs);

            for (Map.Entry<String, String> entry : params.entrySet()) {
                QName qname = new QName(entry.getKey());
                OMElement inner = fac.createOMElement(qname);
                inner.setText(entry.getValue());
                data.addChild(inner);
            }

            OMElement object = serviceClient.sendReceive(data);


            //获取返回结果
            res = object.getFirstElement().getText();
            serviceClient.cleanupTransport();//解决Unable to sendViaPost to url Timeout waiting for connection

        } catch (Exception e) {
            logger.error("----------调用WebServiceUtil.webService服务异常,异常地址：{}，异常信息：{}>>>>------", url, e);
        }

        return res;
    }


    public static String axis2sendRequest(String url, String nameSpace, String methodName, String[] vals, String[] keys) {
        String res = "";
        try {
            ServiceClient sender = new ServiceClient(configurationContext, null);
            EndpointReference endpointReference = new EndpointReference(url);
            Options options = new Options();
            options.setTo(endpointReference);
            options.setProperty(HTTPConstants.SO_TIMEOUT, 120000);
            sender.setOptions(options);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            // 这个和qname差不多，设置命名空间
            OMNamespace omNs = fac.createOMNamespace(nameSpace, methodName);
            OMElement data = fac.createOMElement(methodName, omNs);

            for (int i = 0; i < keys.length; i++) {
                QName qname = new QName(keys[i]);
                OMElement inner = fac.createOMElement(qname);
                inner.setText(vals[i]);
                data.addChild(inner);
            }
            // 发送数据，返回结果
            OMElement result = sender.sendReceive(data);
            //获取返回结果
            res = result.getFirstElement().getText();
        } catch (AxisFault ex) {
            ex.printStackTrace();
        }
        return res;
    }

    static {
        try {
            configurationContext = ConfigurationContextFactory
                    .createConfigurationContextFromFileSystem(null, null);
        } catch (AxisFault axisFault) {
            axisFault.printStackTrace();
        }
    }

}
