package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.estateplat.core.ex.AppException;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * @author: <a href ="mailto:xiejianan@gtmap.cn"></a>
 * @date: Created in 16:00 2018/1/5
 * @description
 */
public class TimeUtils {

//    //获取本月的开始时间
//    public static Date getBeginDayOfMonth() {
//        Calendar calendar = Calendar.getInstance();
//        calendar.set(getNowYear(), getNowMonth() - 1, 1);
//        return getDayStartTime(calendar.getTime());
//    }
//    //获取本月的结束时间
//    public static Date getEndDayOfMonth() {
//        Calendar calendar = Calendar.getInstance();
//        calendar.set(getNowYear(), getNowMonth() - 1, 1);
//        int day = calendar.getActualMaximum(5);
//        calendar.set(getNowYear(), getNowMonth() - 1, day);
//        return getDayEndTime(calendar.getTime());
//    }

    //获取当天的开始时间
    public static String getTimeStr(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String timeStr;
        try {
            timeStr = sdf.format(date);
        } catch (Exception e) {
            timeStr = "";
        }
        return timeStr;
    }

    //获取当天的开始时间
    public static Date getDayBegin() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return cal.getTime();
    }

    //获取当天的结束时间
    public static Date getDayEnd() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return cal.getTime();
    }


    //获取今年是哪一年
    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
        gc.setTime(date);
        return Integer.valueOf(gc.get(1));
    }

    //获取本月是哪一月
    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    //获取本月的开始时间
    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 1, 1);
        return getDayStartTime(calendar.getTime());
    }

    //获取本月的结束时间
    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(getNowYear(), getNowMonth() - 1, day);
        return getDayEndTime(calendar.getTime());
    }


    //    //获取某个日期的开始时间
    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) calendar.setTime(d);
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    //    //获取某个日期的结束时间
    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) calendar.setTime(d);
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 23, 59, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date strToDate(String time) {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date = null;
        try {
            date = sdf.parse(time);
        } catch (ParseException e) {
            throw new AppException(2026);
        }


        return date;
    }

    /**
     * 比较两个日期的大小，有null的时候另算
     *
     * @param date1
     * @param date2
     * @param nullsLater null值是否代表日期更晚
     * @return date1小则返回false
     */
    public static boolean firstDateLater(Date date1, Date date2, boolean nullsLater) {
        if (date1 == null) {
            return nullsLater;
        } else if (date2 == null) {
            return !nullsLater;
        } else {
            return date1.after(date2);
        }
    }

    /**
     * 字符串转成Date
     * @param time
     * @return
     */
    public static Date strToDateTime(String time){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = sdf.parse(time);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return  date;
    }

    /**
     * date 转String
     * @param time
     * @return
     */
    public static String dateToStr(Date time){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String  date = sdf.format(time);
        return  date;
    }

    public static Date getBeforeDay(int day) {
        Calendar c = Calendar.getInstance();
        c.add(Calendar.DATE, day);//把日期往后增加.整数往后推,负数往前移动
        return c.getTime();
    }
}