/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssFilterUtil {
    private static final Logger log = LoggerFactory.getLogger(XssFilterUtil.class);
    private static List<Pattern> PATTERNS = null;
    private static String REGEX = "[\n`~!@#%^&*+=':;'\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\u2014\u2014+]";
    private static Pattern PATTERN = Pattern.compile(REGEX);

    private static List<Object[]> getXssPatternList() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ret.add(new Object[]{"<(no)?script[^>]*>.*?</(no)?script>", 2});
        ret.add(new Object[]{"</script>", 2});
        ret.add(new Object[]{"<script(.*?)>", 2});
        ret.add(new Object[]{"img\\((.*?)\\)", 2});
        ret.add(new Object[]{"email\\((.*?)\\)", 2});
        ret.add(new Object[]{"eval\\((.*?)\\)", 2});
        ret.add(new Object[]{"expression\\((.*?)\\)", 2});
        ret.add(new Object[]{"<(\"[^\"]*\"|'[^']*'|[^'\">])*>", 2});
        ret.add(new Object[]{"<+\\s*\\w*\\s*(alert|oncontrolselect|oncopy|oncut|ondataavailable|ondatasetchanged|ondatasetcomplete|ondblclick|ondeactivate|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onerror=|onerroupdate|onfilterchange|onfinish|onfocus|onfocusin|onfocusout|onhelp|onkeydown|onkeypress|onkeyup|onlayoutcomplete|onload|onlosecapture|onmousedown|onmouseenter|onmouseleave|onmousemove|onmousout|onmouseover|onmouseup|onmousewheel|onmove|onmoveend|onmovestart|onabort|onactivate|onafterprint|onafterupdate|onbefore|onbeforeactivate|onbeforecopy|onbeforecut|onbeforedeactivate|onbeforeeditocus|onbeforepaste|onbeforeprint|onbeforeunload|onbeforeupdate|onblur|onbounce|oncellchange|onchange|onclick|oncontextmenu|onpaste|onpropertychange|onreadystatechange|onreset|onresize|onresizend|onresizestart|onrowenter|onrowexit|onrowsdelete|onrowsinserted|onscroll|onselect|onselectionchange|onselectstart|onstart|onstop|onsubmit|onunload)+\\s*=+", 2});
        return ret;
    }

    private static List<Pattern> getPatterns() {
        if (PATTERNS == null) {
            ArrayList<Pattern> list = new ArrayList<Pattern>();
            String regex = null;
            Integer flag = null;
            int arrLength = 0;
            for (Object[] arr : XssFilterUtil.getXssPatternList()) {
                arrLength = arr.length;
                for (int i = 0; i < arrLength; ++i) {
                    regex = (String)arr[0];
                    flag = (Integer)arr[1];
                    list.add(Pattern.compile(regex, flag));
                }
            }
            PATTERNS = list;
        }
        return PATTERNS;
    }

    public static String stripXss(String value, ServletRequest request) {
        String url = ((HttpServletRequest)request).getServletPath();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Matcher matcher = null;
            for (Pattern pattern : XssFilterUtil.getPatterns()) {
                matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u63a5\u6536\u5b57\u7b26\u662f\uff1a{}", (Object)value);
                value = matcher.replaceAll("");
                OperationalLogUtil.log((HttpServletRequest)request, "0", url + "\u542b\u6709\u975e\u6cd5\u5b57\u7b26", "\u57fa\u7840\u652f\u6491\u5e73\u53f0");
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u5339\u914d\u6b63\u5219\u662f\uff1a{}\uff0c\u5904\u7406\u540e\u662f\uff1a{}", (Object)matcher, (Object)value);
            }
            if (StringUtils.isNotBlank((CharSequence)value) && PATTERN.matcher(value).find()) {
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u63a5\u6536\u5b57\u7b26\u662f\uff1a{}", (Object)value);
                value = PATTERN.matcher(value).replaceAll("").trim();
                OperationalLogUtil.log((HttpServletRequest)request, "0", url + "\u542b\u6709\u975e\u6cd5\u5b57\u7b26", "\u57fa\u7840\u652f\u6491\u5e73\u53f0");
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u7279\u6b8a\u7b26\u53f7\u5904\u7406\u540e\u662f\uff1a{}", (Object)value);
            }
        }
        return value;
    }

    public static String stripXss(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Matcher matcher = null;
            for (Pattern pattern : XssFilterUtil.getPatterns()) {
                matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u63a5\u6536\u5b57\u7b26\u662f\uff1a{}", (Object)value);
                value = matcher.replaceAll("");
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u5339\u914d\u6b63\u5219\u662f\uff1a{}\uff0c\u5904\u7406\u540e\u662f\uff1a{}", (Object)matcher, (Object)value);
            }
            if (StringUtils.isNotBlank((CharSequence)value) && PATTERN.matcher(value).find()) {
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u63a5\u6536\u5b57\u7b26\u662f\uff1a{}", (Object)value);
                value = PATTERN.matcher(value).replaceAll("").trim();
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u7279\u6b8a\u7b26\u53f7\u5904\u7406\u540e\u662f\uff1a{}", (Object)value);
            }
        }
        return value;
    }

    public static String stripXssRes(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Matcher matcher = null;
            for (Pattern pattern : XssFilterUtil.getPatterns()) {
                matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u63a5\u6536\u5b57\u7b26\u662f\uff1a{}", (Object)value);
                value = matcher.replaceAll("");
                log.info("\u3010XSS\u653b\u51fb\u9632\u5fa1\u3011\uff0c\u5339\u914d\u6b63\u5219\u662f\uff1a{}\uff0c\u5904\u7406\u540e\u662f\uff1a{}", (Object)matcher, (Object)value);
            }
        }
        return value;
    }
}

