/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.XmlStemFilter;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileUtil {
    public static byte[] getBytes(File file) {
        ByteSource byteSource = null;
        byteSource = Files.asByteSource((File)file);
        byte[] outBytes = new byte[]{};
        try {
            outBytes = byteSource.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outBytes;
    }

    public static boolean saveFile(byte[] content, File file) {
        try {
            Files.write((byte[])content, (File)file);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileAsString(File file) throws IOException {
        BufferedReader reader = null;
        String fileString = null;
        try {
            reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
            return reader;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            reader.close();
            return fileString;
        }
    }

    public static boolean removeFile(File file) {
        return file.delete();
    }

    public static List<File> getFilesByPath(File file, FileFilter fileFilter) {
        File[] files;
        ArrayList<File> allFile = new ArrayList<File>();
        if (!file.exists()) {
            return null;
        }
        for (File fileDetail : files = file.listFiles()) {
            if (fileDetail.isFile()) {
                if (fileFilter != null && !fileFilter.accept(fileDetail)) continue;
                allFile.add(fileDetail);
            }
            if (!fileDetail.isDirectory()) continue;
            FileUtil.getFilesByPath(fileDetail, fileFilter);
        }
        return allFile;
    }

    public static List<File> getFiles(String path) {
        ArrayList<File> filess = new ArrayList<File>();
        File file = new File(path);
        if (file.exists()) {
            XmlStemFilter xmlStemFilter = new XmlStemFilter();
            Object[] files = file.listFiles();
            Arrays.sort(files);
            if (null == files || files.length == 0) {
                return Lists.newArrayList();
            }
            for (Object file2 : files) {
                if (((File)file2).isDirectory()) {
                    String tempPath = ((File)file2).getAbsolutePath();
                    List<File> fileList = FileUtil.getFiles(tempPath);
                    if (null == fileList || fileList.isEmpty()) continue;
                    for (File fileTemp : fileList) {
                        if (!xmlStemFilter.accept(fileTemp)) continue;
                        filess.add(fileTemp);
                    }
                    continue;
                }
                if (!xmlStemFilter.accept((File)file2)) continue;
                filess.add((File)file2);
            }
        } else {
            file.mkdirs();
        }
        return filess;
    }

    public static List<File> getXSDFiles(String path) {
        ArrayList<File> filess = new ArrayList<File>();
        File file = new File(path);
        if (file.exists()) {
            File[] files = file.listFiles();
            if (null == files || files.length == 0) {
                System.out.println("XSD\u6587\u4ef6\u5939\u662f\u7a7a\u7684!");
                return Lists.newArrayList();
            }
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    String tempPath = file2.getAbsolutePath();
                    List<File> fileList = FileUtil.getFiles(tempPath);
                    if (null == fileList || fileList.isEmpty()) continue;
                    for (File fileTemp : fileList) {
                        filess.add(fileTemp);
                    }
                    continue;
                }
                filess.add(file2);
            }
        } else {
            file.mkdirs();
        }
        return filess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileString(File file) {
        StringBuffer data = new StringBuffer();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((str = in.readLine()) != null) {
                data.append(str + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            e.getStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data.toString();
    }
}

