/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.common;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import com.gtis.config.AppConfig;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;

@Controller
public class BaseInfoController {
    private SecuritySSOHandleService securitySSOHandleService = new SecuritySSOHandleServiceImpl();

    public String getRegionName() {
        XtRegion xtRegion;
        String qhdm = AppConfig.getProperty((String)"region.qhdm");
        String regionName = "";
        if (StringUtils.isNotBlank((CharSequence)qhdm) && null != (xtRegion = this.securitySSOHandleService.getXzqhOne(qhdm))) {
            regionName = xtRegion.getQhmc();
        }
        return regionName;
    }

    public List<XtRegion> getRegionLst() {
        String qhdm = AppConfig.getProperty((String)"region.qhdm");
        List<XtRegion> regionList = new ArrayList<XtRegion>();
        if (StringUtils.isNotBlank((CharSequence)qhdm)) {
            regionList = this.securitySSOHandleService.getXzqhNext(qhdm);
        }
        return regionList;
    }

    public List<XtRegion> getCurrRegionLst(String userid) {
        List<XtRegion> regionList = new ArrayList<XtRegion>();
        if (StringUtils.isNotBlank((CharSequence)userid)) {
            regionList = this.securitySSOHandleService.getCurruserRegion(userid);
        }
        return regionList;
    }

    public List<XtGroup> getCurrGroupLst(String userid) {
        List<XtGroup> groupList = new ArrayList<XtGroup>();
        if (StringUtils.isNotBlank((CharSequence)userid)) {
            groupList = this.securitySSOHandleService.getCurruserGroup(userid);
        }
        return groupList;
    }

    public UserAuthDTO getCurrentUser(HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserAuthDTO userAuthDTO = null;
        if (null == authentication) {
            String cookieName = AppConfig.getProperty((String)"platform.cookiename");
            Cookie[] diskCookies = request.getCookies();
            if (diskCookies != null) {
                for (int i = 0; i < diskCookies.length; ++i) {
                    if (!diskCookies[i].getName().equals(cookieName)) continue;
                    String cookieValue = diskCookies[i].getValue();
                    userAuthDTO = this.securitySSOHandleService.validUser(cookieValue);
                }
            }
        } else {
            Object obj = authentication.getPrincipal();
            if (null != obj && obj instanceof UserAuthDTO) {
                userAuthDTO = (UserAuthDTO)obj;
                userAuthDTO.getAuthorities();
            }
        }
        return userAuthDTO;
    }

    public String getQhjb() {
        XtRegion xtRegion;
        String qhdm = AppConfig.getProperty((String)"region.qhdm");
        String qhjb = "";
        if (StringUtils.isNotBlank((CharSequence)qhdm) && null != (xtRegion = this.securitySSOHandleService.getXzqhOne(qhdm))) {
            qhjb = xtRegion.getQhjb();
        }
        return qhjb;
    }
}

