/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.service.impl;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.entity.XtUser;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.utils.HttpClientUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.gtis.config.AppConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class SecuritySSOHandleServiceImpl
implements SecuritySSOHandleService {
    @Override
    public UserAuthDTO validUser(String uuid) {
        String portalUrl = AppConfig.getProperty((String)"portal.url");
        String url = portalUrl + "/remote/validUser";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("uuid", uuid);
        UserAuthDTO userAuthDTO = null;
        try {
            String json = HttpClientUtil.sendHttpClient(url, paramMap);
            JSONObject jb = JSON.parseObject((String)json);
            userAuthDTO = this.jsonParseUser(jb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return userAuthDTO;
    }

    @Override
    public boolean validResource(String url, String uuid, String groupNo) {
        String portalUrl = AppConfig.getProperty((String)"portal.url");
        String validUrl = portalUrl + "/remote/validResource";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("uuid", uuid);
        paramMap.put("url", url);
        paramMap.put("groupNo", groupNo);
        boolean isValid = false;
        try {
            isValid = Boolean.parseBoolean(HttpClientUtil.sendHttpClient(validUrl, paramMap));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isValid;
    }

    private UserAuthDTO jsonParseUser(JSONObject jo) {
        UserAuthDTO userAuthDTO = null;
        if (null != jo) {
            JSONArray ja;
            userAuthDTO = new UserAuthDTO();
            if (jo.containsKey((Object)"username")) {
                userAuthDTO.setUsername((String)jo.get((Object)"username"));
            }
            if (jo.containsKey((Object)"isAdmin")) {
                userAuthDTO.setIsAdmin((Boolean)jo.get((Object)"isAdmin"));
            }
            if (jo.containsKey((Object)"authorities")) {
                ja = (JSONArray)jo.get((Object)"authorities");
                HashSet<SimpleGrantedAuthority> authSet = new HashSet<SimpleGrantedAuthority>();
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject jsonObject = (JSONObject)ja.get(i);
                    if (jsonObject.containsKey((Object)"authority")) {
                        authSet.add(new SimpleGrantedAuthority((String)jsonObject.get((Object)"authority")));
                    }
                    userAuthDTO.setAuthorities(authSet);
                }
            }
            if (jo.containsKey((Object)"xtUser")) {
                String userJson = JSON.toJSONString((Object)jo.get((Object)"xtUser"));
                XtUser xtUser = (XtUser)JSONObject.parseObject((String)userJson, (TypeReference)new TypeReference<XtUser>(){}, (Feature[])new Feature[0]);
                userAuthDTO.setXtUser(xtUser);
            }
            if (jo.containsKey((Object)"regions")) {
                ja = (JSONArray)jo.get((Object)"regions");
                ArrayList<Map<String, Object>> regions = new ArrayList<Map<String, Object>>();
                if (null != ja && ja.size() > 0) {
                    for (Object object : ja) {
                        regions.add((Map)object);
                    }
                }
                userAuthDTO.setRegions(regions);
            }
            if (jo.containsKey((Object)"passwordTooSimple")) {
                userAuthDTO.setPasswordTooSimple((Boolean)jo.get((Object)"passwordTooSimple"));
            }
        }
        return userAuthDTO;
    }

    @Override
    public XtRegion getXzqhOne(String qhdm) {
        XtRegion xtRegion = new XtRegion();
        String oneUrl = AppConfig.getProperty((String)"portal.url") + "/remote/getXzqhOne";
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("qhdm", qhdm);
        String regionJson = "";
        try {
            regionJson = HttpClientUtil.sendHttpClient(oneUrl, paraMap);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (StringUtils.isNotBlank((CharSequence)regionJson)) {
            regionJson = "[" + regionJson + "]";
            JSONArray ja = JSONArray.parseArray((String)regionJson);
            List<XtRegion> regionLst = this.jsonParseRegion(ja);
            xtRegion = regionLst.get(0);
        }
        return xtRegion;
    }

    @Override
    public List<XtRegion> getXzqhNext(String qhdm) {
        String nextUrl = AppConfig.getProperty((String)"portal.url") + "/remote/getXzqhNext";
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("qhdm", qhdm);
        String regionJson = "";
        try {
            regionJson = HttpClientUtil.sendHttpClient(nextUrl, paraMap);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        List<XtRegion> regionLst = new ArrayList<XtRegion>();
        if (StringUtils.isNotBlank((CharSequence)regionJson)) {
            regionLst = (List)JSON.parseObject((String)regionJson, (TypeReference)new TypeReference<List<XtRegion>>(){}, (Feature[])new Feature[0]);
        }
        return regionLst;
    }

    @Override
    public List<XtRegion> getCurruserRegion(String userId) {
        String nextUrl = AppConfig.getProperty((String)"portal.url") + "/remote/getCurruserRegion";
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("userid", userId);
        String regionJson = "";
        List<XtRegion> regionLst = new ArrayList<XtRegion>();
        try {
            regionJson = HttpClientUtil.sendHttpClient(nextUrl, paraMap);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (StringUtils.isNotBlank((CharSequence)regionJson)) {
            regionLst = (List)JSON.parseObject((String)regionJson, (TypeReference)new TypeReference<List<XtRegion>>(){}, (Feature[])new Feature[0]);
        }
        return regionLst;
    }

    public List<XtRegion> jsonParseRegion(JSONArray ja) {
        ArrayList<XtRegion> resultLst = new ArrayList<XtRegion>();
        if (null != ja) {
            for (int i = 0; i < ja.size(); ++i) {
                XtRegion xtRegion = new XtRegion();
                JSONObject jsonObject = (JSONObject)ja.get(i);
                if (jsonObject.containsKey((Object)"regionId") && null != jsonObject.get((Object)"regionId")) {
                    xtRegion.setRegion_id(jsonObject.get((Object)"regionId").toString());
                }
                if (jsonObject.containsKey((Object)"qhdm") && null != jsonObject.get((Object)"qhdm")) {
                    xtRegion.setQhdm(jsonObject.get((Object)"qhdm").toString());
                }
                if (jsonObject.containsKey((Object)"qhmc") && null != jsonObject.get((Object)"qhmc")) {
                    xtRegion.setQhmc(jsonObject.get((Object)"qhmc").toString());
                }
                if (jsonObject.containsKey((Object)"fdm") && null != jsonObject.get((Object)"fdm")) {
                    xtRegion.setFdm(jsonObject.get((Object)"fdm").toString());
                }
                if (jsonObject.containsKey((Object)"qhjb") && null != jsonObject.get((Object)"qhjb")) {
                    xtRegion.setQhjb(jsonObject.get((Object)"qhjb").toString());
                }
                resultLst.add(xtRegion);
            }
        }
        return resultLst;
    }

    @Override
    public List<XtGroup> getCurruserGroup(String userId) {
        String nextUrl = AppConfig.getProperty((String)"portal.url") + "/remote/getCurruserGroup";
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("userid", userId);
        String groupJson = "";
        List<XtGroup> groupLst = new ArrayList<XtGroup>();
        try {
            groupJson = HttpClientUtil.sendHttpClient(nextUrl, paraMap);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (StringUtils.isNotBlank((CharSequence)groupJson)) {
            groupLst = (List)JSON.parseObject((String)groupJson, (TypeReference)new TypeReference<List<XtGroup>>(){}, (Feature[])new Feature[0]);
        }
        return groupLst;
    }

    @Override
    public List<XtRegion> getRegion(String str) {
        List<XtRegion> regionLst = new ArrayList<XtRegion>();
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Map paraMap = (Map)JSON.parseObject((String)str, Map.class);
            String nextUrl = AppConfig.getProperty((String)"portal.url") + "/remote/getRegion";
            String regionJson = "";
            try {
                regionJson = HttpClientUtil.sendHttpDataClient(nextUrl, paraMap);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            if (StringUtils.isNotBlank((CharSequence)regionJson)) {
                regionLst = (List)JSON.parseObject((String)regionJson, (TypeReference)new TypeReference<List<XtRegion>>(){}, (Feature[])new Feature[0]);
            }
        }
        return regionLst;
    }
}

