package cn.gtmap.realestate.supervise.common;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hqz
 * @version 1.0, 2017/6/14
 * @description 用户信息初始化类
 */
@Controller
public class BaseInfoController {

    private SecuritySSOHandleService securitySSOHandleService = new SecuritySSOHandleServiceImpl();

    //获取行政区列表
    public String getRegionName(){
        String qhdm = AppConfig.getProperty("region.qhdm");
        XtRegion xtRegion;
        String regionName = "";
        if (StringUtils.isNotBlank(qhdm)) {
            xtRegion = securitySSOHandleService.getXzqhOne(qhdm);
            if (null != xtRegion){
                regionName = xtRegion.getQhmc();
            }
        }
        return regionName;
    }

    //根据行政区代码获取名称
    public List<XtRegion> getRegionLst(){
        String qhdm = AppConfig.getProperty("region.qhdm");
        List<XtRegion> regionList = new ArrayList<>();
        if (StringUtils.isNotBlank(qhdm)) {
            regionList = securitySSOHandleService.getXzqhNext(qhdm);
        }
        return regionList;
    }

    //根据行政区代码获取名称
    public List<XtRegion> getCurrRegionLst(String userid){
        List<XtRegion> regionList = new ArrayList<>();
        if (StringUtils.isNotBlank(userid)) {
            regionList = securitySSOHandleService.getCurruserRegion(userid);
        }
        return regionList;
    }

    //根据行政区代码获取名称
    public List<XtGroup> getCurrGroupLst(String userid){
        List<XtGroup> groupList = new ArrayList<>();
        if (StringUtils.isNotBlank(userid)) {
            groupList = securitySSOHandleService.getCurruserGroup(userid);
        }
        return groupList;
    }

    public UserAuthDTO getCurrentUser(HttpServletRequest request){

        Authentication authentication =  SecurityContextHolder.getContext().getAuthentication();
        UserAuthDTO userAuthDTO = null;
        if(null == authentication){
            String cookieName = AppConfig.getProperty("platform.cookiename");
            Cookie[] diskCookies = request.getCookies();
            String cookieValue;
            if (diskCookies != null) {
                for (int i = 0; i < diskCookies.length; ++i) {
                    if (diskCookies[i].getName().equals(cookieName)) {
                        cookieValue = diskCookies[i].getValue();
                        userAuthDTO = securitySSOHandleService.validUser(cookieValue);
                    }
                }
            }
        } else {
            Object obj = authentication.getPrincipal();
            if(null != obj && obj instanceof UserAuthDTO){
                userAuthDTO = (UserAuthDTO) obj;
                userAuthDTO.getAuthorities();
            }
        }
        return userAuthDTO;
    }

    //获取获取区划级别
    public String getQhjb(){
        String qhdm = AppConfig.getProperty("region.qhdm");
        XtRegion xtRegion;
        String qhjb = "";
        if (StringUtils.isNotBlank(qhdm)) {
            xtRegion = securitySSOHandleService.getXzqhOne(qhdm);
            if (null != xtRegion){
                qhjb = xtRegion.getQhjb();
            }
        }
        return qhjb;
    }
}
