/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.AESEncrypter;
import cn.gtmap.realestate.supervise.utils.JedisPoolUtil;
import cn.gtmap.realestate.supervise.utils.TimeUtils;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class TokenPool {
    private static TokenPool tokenPool = null;
    private List<TokenEntry> tokenPools = new ArrayList<TokenEntry>();
    private static final String publickey = "gtmap_wechat";
    private static final int validMinute = 30;
    private static final String REDIS_TOKEN = "TOKEN";
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenPool.class);

    private TokenPool() {
    }

    public static TokenPool getTokenPoolInstance() {
        if (null == tokenPool) {
            tokenPool = new TokenPool();
        }
        return tokenPool;
    }

    public synchronized String getToken(String userId) {
        String token = null;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            token = this.validUserHasToken(userId);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                return token;
            }
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
            String strNow = sf.format(now);
            String content = userId + "|" + strNow;
            byte[] bytes = AESEncrypter.encrypt(content, publickey);
            token = TokenPool.byteArrayToHexStr(bytes);
            Jedis jedis = JedisPoolUtil.getJedis();
            HashMap map = Maps.newHashMap();
            map.put("token_" + userId, token);
            map.put("time_" + userId, strNow);
            map.put("userId_" + userId, userId);
            jedis.hmset(REDIS_TOKEN, (Map)map);
            jedis.close();
        }
        return token;
    }

    public synchronized boolean validToken(String token) {
        boolean isflag = false;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            Jedis jedis = JedisPoolUtil.getJedis();
            Map maps = jedis.hgetAll(REDIS_TOKEN);
            if (maps.containsValue(token)) {
                String tokenKey = "";
                String timeKey = "";
                String userIdKey = "";
                for (Map.Entry entry : maps.entrySet()) {
                    if (!token.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)tokenKey)) continue;
                    tokenKey = (String)entry.getKey();
                    break;
                }
                timeKey = tokenKey.replace("token", "time");
                userIdKey = tokenKey.replace("token", "userId");
                String time = jedis.hget(REDIS_TOKEN, timeKey);
                Date oldDate = TimeUtils.strToDateTime(time);
                boolean isValid = this.validDate(oldDate);
                if (!isValid) {
                    jedis.hdel(REDIS_TOKEN, new String[]{userIdKey, timeKey, tokenKey});
                }
                isflag = isValid;
            }
            jedis.close();
        }
        return isflag;
    }

    private boolean validDate(Date initDate) {
        Calendar cd = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        cd.setTime(initDate);
        cd.add(12, 30);
        return now.before(cd);
    }

    private String validUserHasToken(String userId) {
        String token = null;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            String time;
            Jedis jedis = JedisPoolUtil.getJedis();
            String userIdKey = "userId_" + userId;
            String timeKey = "time_" + userId;
            String tokenKey = "token_" + userId;
            String userIdStr = jedis.hget(REDIS_TOKEN, userIdKey);
            if (StringUtils.isNotEmpty((CharSequence)userIdStr) && StringUtils.equals((CharSequence)userId, (CharSequence)userIdStr) && StringUtils.isNotEmpty((CharSequence)(time = jedis.hget(REDIS_TOKEN, timeKey)))) {
                Date oldDate = TimeUtils.strToDateTime(time);
                boolean isValid = this.validDate(oldDate);
                if (isValid) {
                    token = jedis.hget(REDIS_TOKEN, tokenKey);
                    HashMap map = Maps.newHashMap();
                    map.put(timeKey, TimeUtils.dateToStr(new Date(System.currentTimeMillis())));
                    jedis.hmset(REDIS_TOKEN, (Map)map);
                } else {
                    jedis.hdel(REDIS_TOKEN, new String[]{userIdKey, timeKey, tokenKey});
                }
            }
            jedis.close();
        }
        return token;
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUsernameByToken(String token) {
        String username = "";
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try (Jedis jedis = JedisPoolUtil.getJedis();){
                Map maps = jedis.hgetAll(REDIS_TOKEN);
                if (maps.containsValue(token)) {
                    String tokenKey = "";
                    for (Map.Entry entry : maps.entrySet()) {
                        if (!token.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)tokenKey)) continue;
                        tokenKey = (String)entry.getKey();
                        break;
                    }
                    if (StringUtils.isNotBlank((CharSequence)tokenKey)) {
                        username = tokenKey.replace("token_", "");
                    }
                }
            }
        }
        return username;
    }

    public class TokenEntry {
        String token;
        Date initDate;
        String initUser;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public Date getInitDate() {
            return this.initDate;
        }

        public void setInitDate(Date initDate) {
            this.initDate = initDate;
        }

        public String getInitUser() {
            return this.initUser;
        }

        public void setInitUser(String initUser) {
            this.initUser = initUser;
        }
    }
}

