/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    public static String sendHttpClient(String url, Map<String, String> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    ++i;
                }
                postMethod.addParameters(postData);
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e);
        }
        return null;
    }

    public static String sendHttpClient(String url, Map<String, Object> paramMap, Map<String, String> headers) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> headersKeySet = headers.keySet();
        try {
            postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            postMethod.setRequestBody(JSON.toJSONString(paramMap));
            logger.info(url + "RequestBody:{}", (Object)JSON.toJSONString(paramMap));
            if (CollectionUtils.isNotEmpty(headersKeySet)) {
                for (String key : headersKeySet) {
                    postMethod.addRequestHeader(key, headers.get(key));
                }
            }
            logger.info(url + "RequestHeaders:{}", (Object)JSON.toJSONString((Object)postMethod.getRequestHeaders()));
            postMethod.addRequestHeader("Connection", "close");
            httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
            httpClient.executeMethod((HttpMethod)postMethod);
            InputStream inputStream = postMethod.getResponseBodyAsStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuffer json = new StringBuffer();
            String str = "";
            while ((str = br.readLine()) != null) {
                json.append(str);
            }
            return json.toString();
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e);
            return null;
        }
    }

    public static String sendHttpClient(String url, Map<String, String> paramMap, Cookie[] cookies) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        if (null != cookies && cookies.length != 0) {
            StringBuffer cookieStr = new StringBuffer();
            for (int i = 0; i < cookies.length; ++i) {
                cookieStr.append(cookies[i].getName());
                cookieStr.append("=");
                cookieStr.append(cookies[i].getValue()).append(";");
            }
            postMethod.setRequestHeader("Cookie", cookieStr.toString());
        }
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                NameValuePair[] postData = new NameValuePair[keySet.size()];
                int i = 0;
                for (String key : keySet) {
                    postData[i] = new NameValuePair(key, paramMap.get(key));
                    ++i;
                }
                postMethod.addParameters(postData);
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClient Exception!{}", (Throwable)e);
        }
        return null;
    }

    public static String sendHttpDataClient(String url, Map<String, Object> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpDataClient Exception!{}", (Throwable)e);
        }
        return null;
    }

    public static String sendHttpClientJson(String min, String url, Map<String, Object> paramMap) throws IOException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        PostMethod postMethod = new PostMethod(url);
        Set<String> keySet = paramMap.keySet();
        try {
            if (StringUtils.isNotBlank((CharSequence)min)) {
                int milS = Integer.parseInt(min) * 60 * 1000;
                httpClient.setTimeout(milS);
                httpClient.setConnectionTimeout(milS);
            }
            if (CollectionUtils.isNotEmpty(keySet)) {
                postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
                postMethod.addRequestHeader("Connection", "close");
                httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
                postMethod.setRequestBody(JSON.toJSONString(paramMap));
                httpClient.executeMethod((HttpMethod)postMethod);
                InputStream inputStream = postMethod.getResponseBodyAsStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer json = new StringBuffer();
                String str = "";
                while ((str = br.readLine()) != null) {
                    json.append(str);
                }
                return json.toString();
            }
        }
        catch (Exception e) {
            logger.error("HttpClientUtil.sendHttpClientJson Exception!{}", (Throwable)e);
        }
        return null;
    }

    public static String sendHttpClient(String url) throws IOException {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)url)) {
            CloseableHttpClient client = HttpClients.createDefault();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
            HttpGet httpGet = new HttpGet(url);
            httpGet.setConfig(requestConfig);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                result = EntityUtils.toString((HttpEntity)response.getEntity());
                logger.info("url\u8bf7\u6c42\u6210\u529f,\u7ed3\u679c{}" + result);
            } else if (response.getStatusLine().getStatusCode() == 404) {
                logger.error("url\u65e0\u6cd5\u8bbf\u95ee!");
            } else if (response.getStatusLine().getStatusCode() == 500) {
                logger.error("url\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef!");
            }
        }
        return result;
    }
}

