package cn.gtmap.realestate.supervise.model.graph.base;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:Administrator@gtmap.cn">Administrator</a>
 * @version 1.0, 2017/7/21
 * @description
 */
public class Area extends ArrayList<Line> {

    public List<Line> getLines() {
        return this;
    }

    public void addLine(Line line) {
        this.add(line);
    }

    public void setLines(List<Line> lines) {
        this.addAll(lines);
    }

    public boolean isArea() {
        boolean flag = true;
        for(Line line : this) {
            Point beginPoint = line.getBeginPoint();
            Point endPoint = line.getEndPoint();
            if(beginPoint.getX() != endPoint.getX() || beginPoint.getY() != endPoint.getY()) {
                flag = false;
                break;
            }
        }
        return flag;
    }

    /**
     * 强制修复Area，如果发现不闭环强行处理
     */
    public void MustArea() {
        for(Line line : this) {
            Point beginPoint = line.getBeginPoint();
            Point endPoint = line.getEndPoint();
            if(beginPoint.getX() != endPoint.getX() || beginPoint.getY() != endPoint.getY()) {
                Point newEndPoint = new Point();
                newEndPoint.setX(beginPoint.getX());
                newEndPoint.setY(beginPoint.getY());
                line.add(newEndPoint);
            }
        }
    }
}
