package cn.gtmap.realestate.supervise.entity;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author hqz
 * @version 1.0, 2017/5/25
 * @description 用户信息组织类，需要实现UserDetails
 */
public class UserAuthDTO implements UserDetails {

    /**
     * 权限集合
     */
    private Collection<? extends GrantedAuthority> authorities;

    /**
     * 密码
     */
    private String password;

    /**
     * 用户名（登陆名）
     */
    private String username;

    /**
     * 包含的角色
     */
    private List<Map<String, Object>> roles;

    /**
     * 包含的行政区权限
     */
    private List<Map<String,Object>> regions;
    /**
     * 包含的菜单权限
     */
    private LinkedHashMap<String,LinkedHashMap<String,XtResource>> resourceMap;

    /**
     * 系统用户类
     */
    private XtUser xtUser;

    /**
     * 是否禁用
     */
    private boolean enabled;

    /**
     * 是否过期
     */
    private boolean accountNonExpired;

    /**
     * 是否锁定
     */
    private boolean accountNonLocked;

    /**
     * 证书是否过期
     */
    private boolean credentialsNonExpired;

    /**
     * 常州平台单点登录token令牌
     */
    private String token;

    /**
     * 是不是超级管理员
     */
    private Boolean isAdmin;


    public Collection<? extends GrantedAuthority> getAuthorities()
    {
        return authorities;
    }


    public void setAuthorities(Collection<? extends GrantedAuthority> authorities)
    {
        this.authorities = authorities;
    }

    @Override
    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<Map<String, Object>> getRoles() {
        return roles;
    }

    public void setRoles(List<Map<String, Object>> roles) {
        this.roles = roles;
    }

    public XtUser getXtUser() {
        return xtUser;
    }

    public void setXtUser(XtUser xtUser) {
        this.xtUser = xtUser;
    }

    @Override
    public boolean isAccountNonExpired() {
        return accountNonExpired;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    @Override
    public boolean isAccountNonLocked() {
        return accountNonLocked;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return credentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    public LinkedHashMap<String, LinkedHashMap<String, XtResource>> getResourceMap() {
        return resourceMap;
    }

    public void setResourceMap(LinkedHashMap<String, LinkedHashMap<String, XtResource>> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getIsAdmin() {
        return isAdmin;
    }

    public void setIsAdmin(Boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public List<Map<String, Object>> getRegions() {
        return regions;
    }

    public void setRegions(List<Map<String, Object>> regions) {
        this.regions = regions;
    }
}
