package cn.gtmap.realestate.supervise.entity;

import javax.persistence.Id;
import javax.persistence.Table;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author szh
 * 监管规则结果实体类
 */
@Table(name = "jg_result")
public class JgResult {
    @Id
    // 主键
    private String id;

    // 规则编码
    private String ruleCode;

    // 规则类型
    private String ruleType;

    //违规时间
    private Date checkTime;

    //违规信息
    private String checkMessage;

    //行政区代码
    private String checkRegion;

    //违规业务号
    private String ywh;

    //违规登记时间
    private Date djsj;

    //审核状态（0：未确认，1：已下发，2：已忽略，3：已处理，4：已驳回，5：已确认）
    private String resultState;

    //区县处理人
    private String handleUser;

    //区县处理时间
    private Date handleTime;

    //转发意见
    private String replayOpinion;

    //区县意见
    private String regionOpinion;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public String getRuleType() {
        return ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public String getCheckMessage() {
        return checkMessage;
    }

    public void setCheckMessage(String checkMessage) {
        this.checkMessage = checkMessage;
    }

    public String getCheckRegion() {
        return checkRegion;
    }

    public void setCheckRegion(String checkRegion) {
        this.checkRegion = checkRegion;
    }

    public String getRegionOpinion() {
        return regionOpinion;
    }

    public void setRegionOpinion(String regionOpinion) {
        this.regionOpinion = regionOpinion;
    }

    public String getYwh() {
        return ywh;
    }

    public void setYwh(String ywh) {
        this.ywh = ywh;
    }

    public Date getDjsj() {
        return djsj;
    }

    public void setDjsj(Date djsj) {
        this.djsj = djsj;
    }

    public String getResultState() {
        return resultState;
    }

    public void setResultState(String resultState) {
        this.resultState = resultState;
    }

    public String getHandleUser() {
        return handleUser;
    }

    public void setHandleUser(String handleUser) {
        this.handleUser = handleUser;
    }

    public String getHandleTimeStr() {
        if (null != handleTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(handleTime);
        }
        return "";
    }

    public Date getHandleTime() {
        return handleTime;
    }

    public void setHandleTime(Date handleTime) {
        this.handleTime = handleTime;
    }

    public String getReplayOpinion() {
        return replayOpinion;
    }

    public void setReplayOpinion(String replayOpinion) {
        this.replayOpinion = replayOpinion;
    }
}
