package cn.gtmap.realestate.supervise.common;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/10/12
 * @description 常量定义类
 */
public final class Constant {

    /**
     * 系统处理正常
     */
    public static final String SUCCESS = "0000";

    /**
     * 查询条件为空
     */
    public static final int CXTJWK = 1001;

    /**
     * 查询条件格式错误
     */
    public static final int CXTJGSCW = 1002;

    /**
     * 查询结果已反馈至共享部门
     */
    public static final int CXJGYFK = 1003;


    /**
     * 用户名密码验证错误
     */
    public static final int YHMMMCW = 2001;

    /**
     * 安全token错误
     */
    public static final int TOKEN = 2002;

    /**
     * 查询权限错误
     */
    public static final int CXQXCW = 2003;

    /**
     * 查询业务类别错误
     */
    public static final int CXYWLBCW = 2004;

    /**
     * 查询结果不规范：详细缺失字段信息。
     * 如，“房地产权信息中不动产单元号不能为空！”
     * （在所有字段验证完后反馈）
     */
    public static final int CXJGCW = 2005;

    /**
     * 查询申请单号错误
     */
    public static final int CXSQDHCW = 2006;


    /**
     * 查询数据超过100条
     */
    public static final int CXSJCW = 2007;

    /**
     * 文书编号错误
     */
    public static final int WSBHCW = 2008;

    /**
     * 获取token依据错误
     */
    public static final int CXYJCW = 2009;


    /**
     * 查询文书不存在
     */
    public static final int CXWSBCZ = 2010;

    /**
     * 查询文书不存在
     */
    public static final int GXBMFWYC = 2011;

    /**
     * 文书接受异常
     */
    public static final int WSJSYC = 2012;

    /**
     * 申请单号结果已被领取
     */
    public static final int SQDHJGYBLQ = 2013;

    /**
     * 文书过大
     */
    public static final int GXWSGD = 2014;

    /**
     * 查询结果不存在
     */
    public static final int CXJGBCZ = 3001;

    //查询结果尚未反馈
    public static final int CXJGSWFK = 3006;

    public static  final int XTYC = 3007;

    public static  final int JGYWLBGX = 3009;

    public static  final int JGBGX = 3010;

    public static  final int JGZDGX = 3011;

    public static  final int QXFKJGYC = 3012;

    public static  final int QQMZTKYC = 3013;

    public static  final int RCCSYW = 3014;

    /**
     * 查询参数数量限制
     */
    public static  final int CXCSSL=10;

    public static final Map<Object, String> RESP_INFO = new HashMap<Object, String>();

    static {
        RESP_INFO.put(SUCCESS, "成功");
        RESP_INFO.put(CXTJWK, "查询条件为空");
        RESP_INFO.put(CXTJGSCW, "查询条件格式错误");
        RESP_INFO.put(CXJGYFK, "查询结果已反馈至共享部门");
        RESP_INFO.put(YHMMMCW, "用户名密码验证错误");
        RESP_INFO.put(TOKEN, "安全token错误");
        RESP_INFO.put(CXQXCW, "查询权限错误");
        RESP_INFO.put(CXYWLBCW, "查询业务类别错误");
        RESP_INFO.put(CXJGCW, "查询结果不规范:");
        RESP_INFO.put(CXSQDHCW, "查询申请单号错误");
        RESP_INFO.put(CXSJCW, "查询数据超过10条");
        RESP_INFO.put(CXJGBCZ, "查询结果不存在");
        RESP_INFO.put(WSBHCW, "文书编号错误");
        RESP_INFO.put(CXYJCW, "获取token依据错误");
        RESP_INFO.put(CXJGSWFK, "查询结果尚未反馈");
        RESP_INFO.put(WSJSYC, "文书接受异常");
        RESP_INFO.put(CXWSBCZ, "查询文书不存在");
        RESP_INFO.put(GXBMFWYC, "共享部门服务异常");
        RESP_INFO.put(XTYC, "系统异常,请联系管理员!");
        RESP_INFO.put(SQDHJGYBLQ, "申请单号结果已经被领取!");
        RESP_INFO.put(JGYWLBGX, "机构业务类别关系不存在");
        RESP_INFO.put(JGBGX, "机构表关系不存在");
        RESP_INFO.put(JGZDGX, "机构字段关系不存在");
        RESP_INFO.put(QXFKJGYC, "反馈结果不全");
        RESP_INFO.put(GXWSGD, "文书过大，文书应不大于5M");
        RESP_INFO.put(QQMZTKYC, "获取民政token异常");
        RESP_INFO.put(RCCSYW, "入参参数有误");
    }
    public static String getMsg(Object code){
        return RESP_INFO.get(code);
    }


    /*操作名称，用于日志记录*/
    public static final String DELYWLB = "删除业务类别";
    public static final String ADDYWLB = "添加业务类别";
    public static final String UPDYWLB = "更新业务类别";
    public static final String CHANGEYWLB = "修改业务类别状态";

    public static final String ADDRCZD = "添加入参字段";
    public static final String UPDRCZD = "更新入参字段";
    public static final String DELRCZD = "删除入参字段";

    public static final String ADDCCZD = "添加出参字段";
    public static final String UPDCCZD = "更新出参字段";
    public static final String DELCCZD = "删除出参字段";

    public static final String ADDCCB = "添加出参表";
    public static final String UPDCCB = "更新出参表";
    public static final String DELCCB = "删除出参表";

    public static final String ADDQXXX = "添加区县信息";
    public static final String UPDQXXX = "更新区县信息";
    public static final String DELQXXX = "删除区县信息";
    public static final String CHANGEQXXX = "修改区县接入状态";

    public static final String ADDJGXX = "添加机构信息";
    public static final String UPDJGXX = "更新机构信息";
    public static final String DELJGXX = "删除机构信息";
    public static final String SPJGXX = "审批机构信息";
    public static final String CHANGEJGXX = "修改机构启用状态";

    public static final String ADDJGCCZD = "添加机构出参字段";
    public static final String ADDJGCCB = "添加机构出参表";
    public static final String ADDJGYWLB = "添加机构业务类别";
    public static final String DELJGCCZD = "删除机构出参字段";
    public static final String DELJGCCB = "删除机构出参表";




}
