var $, table, element, laytpl, layer, carousel;
layui.use(['jquery', 'table', 'element', 'carousel', 'form', 'laytpl', 'layer'], function () {
    $ = layui.jquery,
        table = layui.table,
        element = layui.element,
        laytpl = layui.laytpl,
        layer = layui.layer,
        carousel = layui.carousel;
});

// 创建任务
function startUpProcess(data) {
    if (data) {
        $.ajax({
            type: "GET",
            url: getContextPath() + "/rest/v1.0/workflow/process-instances/process/param",
            success: function (param) {
                layer.open({
                    type: 2,
                    skin: 'layui-layer-lan',
                    title: '选择不动产单元',
                    area: ['95%', '95%'],
                    content: 'http://192.168.0.47:8687/realestate-accept-ui/view/query/selectBdcdyh.html?processDefKey=' + data.processDefKey + '&jbxxid=' + param,
                    end: function () {
                        closeParentWindow();
                    }
                });
            }, error: function (e) {
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }

            }
        });

    } else {
        layer.msg('创建失败！');
    }
}

//转发操作
function forwardProcess(checkData, url, tableId, currentId) {
    if (!checkStaus(checkData, 1, '转发')) {
        return false;
    }
    if (isEnd(checkData.taskId)) {
        layer.confirm('您确定要办结吗？', {
            title: '提示',
            btn: ['确定', '取消'] //按钮
        }, function () {
            endProcess(checkData, url, tableId, currentId);
        });
    } else {
        layer.open({
            type: 2,
            skin: 'layui-layer-lan',
            title: '任务转发',
            area: ['960px', '490px'],
            content: '../view/send.html?name=' + checkData.taskId + "&isEnd=" + isEnd(checkData.taskId),
            end: function () {
                closeParentWindow();
                renderTable(url, tableId, currentId);
            }
        });
    }
}


//退回操作
function backProcess(checkData, url, tableId, currentId) {
    if (!checkStaus(checkData, 5, '退回')) {
        return false;
    }
    if (allowBack(checkData.taskId)) {
        layer.open({
            title: '退回',
            type: 2,
            skin: 'layui-layer-lan',
            area: ['430px', '430px'],
            content: './back-info.html?taskId=' + checkData.taskId,
            end: function () {
                renderTable(url, tableId, currentId);
            }
        });
    }
}

function claimProcess(checkStatus, url, tableId, currentId) {
    var checkResult = true;
    var taskIds = [];
    checkStatus.data.forEach(function (v, i) {
        checkResult = checkStaus(v, 6, '认领');
        if (!checkResult) {
            return false;
        }
        taskIds.push(v.taskId);
    });
    console.log(taskIds);
    var logoutIndex = layer.confirm('您确定要认领吗？', {
        title: '提示',
        btn: ['确定', '取消'] //按钮
    }, function () {
        $.ajax({
            type: "post",
            url: getContextPath() + "/rest/v1.0/workflow/process-instances/task/claim",
            traditional: true,
            data: {taskIds: taskIds},
            success: function (data) {
                layer.msg('认领成功');
                renderTable(url, tableId, currentId);
            }, error: function (e) {
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }
            }
        });
    });
}

//判断是否可以退回
function allowBack(taskId) {
    var isAllow = false;
    $.ajax({
        type: "get",
        async: false,
        url: getContextPath() + "/rest/v1.0/workflow/process-instances/back/isAllow",
        data: {
            taskId: taskId
        },
        success: function (data) {
            data.code == 0 ? isAllow = true : layer.msg(data.msg);
        }, error: function (e) {
            if(e.status==500){
                var responseText = JSON.parse(e.responseText);
                layer.msg(responseText.msg);
            }else{
                layer.msg('请求异常！');
            }
        }
    });
    return isAllow;
}

//判断是否可以取回
function allowFetchBack(taskId) {
    var isAllowFetchBack = false;
    $.ajax({
        type: "get",
        async: false,
        url: getContextPath() + "/rest/v1.0/workflow/process-instances/task/isAllowFetchBack",
        data: {
            taskId: taskId
        },
        success: function (data) {
            data.code == 0 ? isAllowFetchBack = true : layer.msg(data.msg);
        }, error: function (e) {
            if(e.status==500){
                var responseText = JSON.parse(e.responseText);
                layer.msg(responseText.msg);
            }else{
                layer.msg('请求异常！');
            }
        }
    });
    return isAllowFetchBack;
}

function fetchProcess(checkData, doneUrl, doneTableId, doneCurrentId) {
    if(!allowFetchBack(checkData.taskId)){
        return false;
    }
    console.log(checkData);
    var logoutIndex = layer.confirm('您确定要取回吗？', {
        title: '提示',
        btn: ['确定', '取消'] //按钮
    }, function () {
        $.ajax({
            type: "get",
            url: getContextPath() + "/rest/v1.0/workflow/process-instances/task/fetchBack",
            traditional: true,
            data: {taskId: checkData.taskId},
            success: function (data) {
                layer.msg('取回成功');
                renderTable(doneUrl, doneTableId, doneCurrentId);
            }, error: function (e) {
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }
            }
        });
    });
}

//挂起任务
function hangUpProcess(checkData, url, tableId, currentId) {
    if (!checkStaus(checkData, 3, '挂起')) {
        return false;
    }
    // 挂起当前任务
    $.ajax({
        type: "post",
        url: getContextPath() + "/rest/v1.0/workflow/process-instances/hang",
        data: {
            processInstanceId: checkData.processInstanceId
        },
        success: function (data) {
            layer.msg('挂起成功');
            renderTable(url, tableId, currentId);
        }, error: function (e) {
            if(e.status==500){
                var responseText = JSON.parse(e.responseText);
                layer.msg(responseText.msg);
            }else{
                layer.msg('请求异常！');
            }
        }
    });

}

//删除任务
function deleteProcess(checkData, url, tableId, currentId) {
    if (!checkStaus(checkData, 2, '删除')) {
        return false;
    }
    var logoutIndex = layer.confirm('您确定要删除吗？', {
        title: '提示',
        btn: ['确定', '取消'] //按钮
    }, function () {
        $.ajax({
            type: "post",
            url: getContextPath() + "/rest/v1.0/workflow/process-instances",
            data: {
                _method: "DELETE",
                taskId: checkData.taskId,
                gzlslid: checkData.processInstanceId
            },
            success: function (data) {
                layer.msg('删除成功');
                renderTable(url, tableId, currentId);
            }, error: function (e) {
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }
            }
        });
    });
}

//激活流程
function activeProcess(checkData, url, tableId, currentId) {
    if (!checkStaus(checkData, 4, '激活')) {
        return false;
    }
    $.ajax({
        type: "POST",
        url: getContextPath() + "/rest/v1.0/workflow/process-instances/activate",
        data: {
            processInstanceId: checkData.processInstanceId
        },
        success: function (data) {
            layer.msg('激活成功');
            renderTable(url, tableId, currentId);
        }, error: function (e) {
            if(e.status==500){
                var responseText = JSON.parse(e.responseText);
                layer.msg(responseText.msg);
            }else{
                layer.msg('请求异常！');
            }
        }
    });
}

//表格刷新
function renderTable(url, tableId, currentId) {
    table.reload(currentId, {});
}

//判断是否可以办结
function isEnd(taskId) {
    var isEnd = false;
    //获取转发按钮还是办结按钮
    $.ajax({
        type: "GET",
        async: false,
        url: getContextPath() + "/rest/v1.0/workflow/process-instances/forward/isEnd",
        data: {
            taskId: taskId
        },
        success: function (data) {
            console.log(data);
            isEnd = data;
        }, error: function (e) {
            if(e.status==500){
                var responseText = JSON.parse(e.responseText);
                layer.msg(responseText.msg);
            }else{
                layer.msg('请求异常！');
            }
        }
    });
    return isEnd;
}

//办结
function endProcess(checkData, url, tableId, currentId) {
    var end = false;
    $.ajax({
        type: "POST",
        url: getContextPath() + "/rest/v1.0/workflow/process-instances/end",
        data: {taskId: checkData.taskId},
        async: false,
        success: function () {
            layer.msg("办结成功！");
            renderTable(url, tableId, currentId);
        }, error: function (e) {
            if(e.status==500){
                var responseText = JSON.parse(e.responseText);
                layer.msg(responseText.msg);
            }else{
                layer.msg('请求异常！');
            }
        }
    });
    return end;
}

// 1:转发 2:删除 3:挂起 4: 激活 5:退回 6：认领 7：取回
var forbiddenActive = [4];
var forbiddenHangUp = [1, 2, 3, 5, 6, 7];
var forbiddenClock = [1, 2, 3, 5, 6, 7];
var forbiddenCancel = [4];

function checkStaus(checkData, staus, type) {
    var result = false;
    if ((checkData.state == 1 || isNullOrEmpty(checkData.state)) && (forbiddenActive.indexOf(staus) != -1)) {
        layer.msg('流程已激活,不能进行' + type + '!');
    } else if (checkData.state == 2 && (forbiddenHangUp.indexOf(staus) != -1)) {
        layer.msg('流程已挂起,不能进行' + type + '!');
    } else if (checkData.state == 3 && (forbiddenClock.indexOf(staus) != -1)) {
        layer.msg('流程已锁定,不能进行' + type + '!');
    } else if (checkData.state == 4 && (forbiddenCancel.indexOf(staus) != -1)) {
        layer.msg('流程已解除,不能进行' + type + '!');
    } else {
        result = true;
    }
    return result;
}