/**
 * Created by Administrator on 2019/1/21.
 */
layui.use(['jquery', 'table', 'element', 'carousel', 'form', 'laytpl', 'layer'], function () {
    var $ = layui.jquery,
        table = layui.table,
        element = layui.element,
        laytpl = layui.laytpl,
        layer = layui.layer,
        carousel = layui.carousel;

    $(function () {
        var $paramArr = [];

        function getIpHz() {
            var $params = window.location.search.replace('?', '');
            var $paramSplit = $params.split('&');
            for (var i in $paramSplit) {
                var $subParam = $paramSplit[i].split('=');
                $paramArr[$subParam[0]] = $subParam[1];
            }
        }

        getIpHz();
        var clientId = $paramArr['clientId'];
        // 获取子系统列表
        $.ajax({
            type: "GET",
            url: getContextPath() + "/rest/v1.0/user/modules/portaluiclient/subsystem",
            success: function (data) {
                var path = document.location.pathname + document.location.search;
                data.forEach(function (v) {
                    if (v.url == path) {
                        $('.bdc_subsystem').html(v.name);
                    }
                });
                var getSystemTpl = systemTyl.innerHTML
                    , getSystemView = document.getElementById('systemView');
                laytpl(getSystemTpl).render(data, function (html) {
                    getSystemView.innerHTML = html;
                });
            },error: function(e){
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }
            }
        });

        //点击退出
        $('.bdc-logout').on('click', function () {
            var logoutIndex = layer.confirm('您确定要退出吗？', {
                title: '提示',
                btn: ['确定', '取消'] //按钮
            }, function () {
                layer.close(logoutIndex);
                window.location.href = getContextPath() + "/rest/v1.0/user/logout";
            });
        });

        //获取基本信息
        $.ajax({
            type: "GET",
            url: getContextPath() + "/rest/v1.0/user/info",
            data: {},
            success: function (data) {
                // console.log(data);
                $('.bdc-person-nav .bdc-user-name').html(data.alias);
            },error: function(e){
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }
            }
        });

        //点击基本信息
        $('.bdc-message').on('click', function () {
            $(this).parents('.bdc-person-child').removeClass('layui-show');
            var $parentLi = $('.layui-side-menu .layui-nav-tree li');
            var liLength = $parentLi.length;
            $parentLi.removeClass('layui-nav-itemed');
            $($parentLi[liLength - 1]).addClass('layui-nav-itemed');
            $($parentLi[liLength - 1]).find('dd:first-child a').click();
        });
        //点击修改密码
        $('.bdc-update').on('click', function () {
            $(this).parents('.bdc-person-child').removeClass('layui-show');
            var $parentLi = $('.layui-side-menu .layui-nav-tree li');
            var liLength = $parentLi.length;
            $parentLi.removeClass('layui-nav-itemed');
            $($parentLi[liLength - 1]).addClass('layui-nav-itemed');
            $($parentLi[liLength - 1]).find('dd:last-child a').click();
        });

        // 侧边栏动态渲染
        $.ajax({
            type: "GET",
            url: getContextPath() + "/rest/v1.0/user/menu/" + clientId,
            data: {},
            success: function (data) {
                console.log(data);
                data.push({
                    name: '设置',
                    childTree: [
                        {
                            childTree: [],
                            name: '基本资料',
                            mark: 'basic',
                            url: getContextPath() + '/view/basic-info.html'
                        },
                        {
                            childTree: [],
                            name: '修改密码',
                            mark: 'update',
                            url: getContextPath() + '/view/update-pwd.html'
                        }
                    ]
                });
                var getAsideTpl = asideTpl.innerHTML
                    , getAsideView = document.getElementById('LAY-system-side-menu');
                laytpl(getAsideTpl).render(data, function (html) {
                    getAsideView.innerHTML = html;
                });
                element.render('nav', 'layadmin-system-side-menu');
            },
            error: function(e){
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }
            }
        });

        //1. 监听侧边栏点击
        $('.layui-side-menu .layui-nav-item .layui-nav-child').on('click', function () {
            $('.bdc-four-list').hide();
            // $('.breadcrumb-div cite').html($(this).siblings().find('cite').html());
        });
        $('.layui-side-menu .bdc-mime').on('click', function () {
            $('.bdc-four-list').hide();
            // $('.breadcrumb-div cite').html($(this).find('cite').html());
        });
        //1.1 监听三级菜单点击
        $('.layui-side-menu .layui-nav').on('click', '.layui-nav-child .layui-nav-child a', function (e) {
            // console.log($(this).offset().top);
            // e.stopPropagation();
            $('.bdc-four-list').hide();
            $(this).siblings().css('top', $(this).offset().top).toggle();
        });
        //1.2 点击四级菜单点击
        $('.layui-side').on('click', '.bdc-four-list p', function () {
            $(this).parent().css('display', 'none');
        });

        //2. 调整左侧滑动条的位置
        $('.layui-side-menu .layui-nav-item>a').on('click', function () {
            $('.bdc-four-list').hide();
            $('.layui-nav-bar').css({'height': '50px', 'opacity': 1, 'top': $(this).parent().index() * 50});
        });

        //3. 消息列表相关
        //3.1 消息列表高度
        $('.bdc-msg-child').height($('.layui-body').height() + 50);
        $('.bdc-msg-child .layui-tab-item').height($('.layui-body').height() - 116);
        //3.2 点击消息列表中的‘×’，关闭
        $('.bdc-msg-title .layui-icon-close').on('click', function () {
            $('.bdc-msg-child').removeClass('layui-show');
        });

        //4. 轮播图
        //4.0 渲染常用收藏内容
        var commonConnection = false;
        var connectionList = false;
        //监听收藏tab切
        element.on('tab(task)', function (data) {
            switch (data.index) {
                case 0:
                    if (connectionList) {
                        renderCommonCollection();
                    }
                    break;
                case 1:
                    if (commonConnection) {
                        renderLbList();
                    }
                    break;
            }
        });
        renderCommonCollection();

        function renderCommonCollection() {
            $.ajax({
                type: "GET",
                url: getContextPath() + "/rest/v1.0/collect",
                dataType: "json",
                contentType: "application/json",
                data: {},
                success: function (data) {
                    // console.log(data);
                    var getCollectionTpl = collectionTpl.innerHTML
                        , collectionView = document.getElementById('collectionView');
                    laytpl(getCollectionTpl).render(data, function (html) {
                        collectionView.innerHTML = html;
                    });
                },
                error: function(e){
                    if(e.status==500){
                        var responseText = JSON.parse(e.responseText);
                        layer.msg(responseText.msg);
                    }else{
                        layer.msg('请求异常！');
                    }
                }
            });
        }
        //监听常用收藏中的收起，展示
        var isShowMoreCellection = false;
        $('.bdc-task-content').on('click','.bdc-show-more-collection span',function () {
            isShowMoreCellection = !isShowMoreCellection;
            $('.bdc-show-more-collection span').toggleClass('bdc-hide');
            if(isShowMoreCellection){
                $('.bdc-collection-content').css("height",'auto');
            }else {
                $('.bdc-collection-content').css('height','84px');
            }
        });

        //4.0.1 点击收藏中的星星图标，取消收藏
        $('.bdc-collection-tab').on('click', '.bdc-collection-content .layui-icon-rate-solid', function () {
            commonConnection = true;
            var code = $(this).data('code');
            $.ajax({
                type: "post",
                url: getContextPath() + "/rest/v1.0/collect/user",
                data: {
                    _method: "DELETE",
                    "code": code
                },
                success: function (data) {
                    layer.msg('取消收藏成功');
                    renderCommonCollection();
                },error: function(e){
                    if(e.status==500){
                        var responseText = JSON.parse(e.responseText);
                        layer.msg(responseText.msg);
                    }else{
                        layer.msg('请求异常！');
                    }
                }
            });
        });

        //4.1 轮播图 内容、一屏展示几个，可配置
        //默认一屏展示5个，大数组里面嵌套数组，展示几个，嵌套数组中存储几条数据
        renderLbList();

        function renderLbList() {
            $.ajax({
                type: "GET",
                url: getContextPath() + "/rest/v1.0/task/list",
                data: {},
                success: function (data) {
                    // console.log(data);
                    var carouselData = [];
                    for (var i = 0; i < Math.ceil(data.content.length / data.size); i++) {
                        carouselData.push([]);
                    }
                    data.content.forEach(function (v, i) {
                        var getIndex = i + 1;
                        carouselData[Math.ceil(getIndex / data.size) - 1].push(v);
                    });
                    // console.log(carouselData);
                    var getCarouselTpl = carouselTpl.innerHTML
                        , getCarouselView = document.getElementById('carouselView');
                    laytpl(getCarouselTpl).render(carouselData, function (html) {
                        getCarouselView.innerHTML = html;
                    });
                    $('.bdc-carousel-father .bdc-carousel-son').css('width', 100 / carouselData.size + '%');
                    $('.bdc-carousel-details').css('width', carouselData.size * 100 + '%');

                    carousel.render({
                        elem: '#buildTask',
                        width: '100%',
                        height: '64px',
                        arrow: 'always',
                        indicator: 'outside',
                        autoplay: false
                    });
                },error: function(e){
                    if(e.status==500){
                        var responseText = JSON.parse(e.responseText);
                        layer.msg(responseText.msg);
                    }else{
                        layer.msg('请求异常！');
                    }
                }
            });
        }

        //4.2 轮播图内鼠标覆盖事件
        var $carouselTask = $('#buildTask');
        $carouselTask.on('mouseenter', '.bdc-carousel-son', function () {
            $(this).find('.bdc-carousel-img').toggleClass('bdc-hide');
        }).on('mouseleave', '.bdc-carousel-son', function () {
            $(this).find('.bdc-carousel-img').toggleClass('bdc-hide');
            if (!$(this).find('.bdc-carousel-details').hasClass('bdc-hide')) {
                $(this).find('.bdc-carousel-details').addClass('bdc-hide');
            }
        });
        //4.3 轮播图内单击事件
        $carouselTask.on('click', '.bdc-carousel-son', function () {
            // console.log($(this).width());
            $(this).find('.bdc-carousel-details').css('left', -($(this).index() * $(this).width()) - ($(this).index() * 20) - 20 + 'px').removeClass('bdc-hide');
        });
        //4.4 控制tab切内容显示与隐藏
        $('.bdc-operate-show>.layui-icon').on('click', function () {
            $('.bdc-operate-show>.layui-icon').toggleClass('bdc-hide');
            $('.bdc-task-content').toggleClass('bdc-hide');
            $('.bdc-task-search-box').toggleClass('bdc-hide');
        });
        //4.5 轮播图详情页
        //4.5.1 单击 × 按钮，关闭详情
        $carouselTask.on('click', '.bdc-carousel-close', function (event) {
            event.stopPropagation();
            $(this).parent().addClass('bdc-hide');
        });
        //4.5.2 ☆ 图标显示与隐藏
        var $buildTask = $('.bdc-build-task');
        var $buildCollectionTask = $('#collectionView');
        var $buildTaskTab = $('.bdc-task-tab');
        var $searchContent = $('.bdc-search-content');
        $buildTaskTab.on('mouseenter', '.bdc-details-type-content>a', function () {
            if (!$(this).find('.layui-icon').hasClass('layui-icon-rate-solid')) {
                $(this).find('.layui-icon').toggleClass('bdc-visible');
            }
        }).on('mouseleave', '.bdc-details-type-content>a', function () {
            if (!$(this).find('.layui-icon').hasClass('layui-icon-rate-solid')) {
                $(this).find('.layui-icon').toggleClass('bdc-visible');
            }
        });
        //4.5.3 单击☆图标，收藏或取消收藏
        $buildTask.on('click', '.bdc-details-type-content>a>.layui-icon', function (e) {
            e.stopPropagation();
            connectionList = true;
            var _this = $(this);
            var type = $(this).data('type');
            var code = $(this).data('code');
            var name = $(this).data('name');
            var id = $(this).data('id');
            var date = (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
            if ($(this).hasClass('layui-icon-rate')) {
                //未收藏，收藏
                $.ajax({
                    type: "PUT",
                    url: getContextPath() + "/rest/v1.0/collect/user",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify({
                        "code": code,
                        "content": "",
                        "createAt": date,
                        "id": id,
                        "name": name,
                        "typeName": name
                    }),
                    success: function (data) {
                        // console.log(data);
                        layer.msg('收藏成功');
                        _this.removeClass('layui-icon-rate bdc-visible').addClass('layui-icon-rate-solid');
                    },error: function(e){
                        if(e.status==500){
                            var responseText = JSON.parse(e.responseText);
                            layer.msg(responseText.msg);
                        }else{
                            layer.msg('请求异常！');
                        }
                    }
                });
            } else {
                //已收藏 取消收藏
                $.ajax({
                    type: "post",
                    url: getContextPath() + "/rest/v1.0/collect/user",
                    data: {
                        _method: "DELETE",
                        "code": code
                    },
                    success: function (data) {
                        // console.log(data);
                        layer.msg('取消收藏成功');
                        _this.removeClass('layui-icon-rate-solid bdc-visible').addClass('layui-icon-rate');
                    },error: function(e){
                        if(e.status==500){
                            var responseText = JSON.parse(e.responseText);
                            layer.msg(responseText.msg);
                        }else{
                            layer.msg('请求异常！');
                        }
                    }
                });
            }
        });
        $searchContent.on('click', '.bdc-details-type-content>a>.layui-icon', function (e) {
            e.stopPropagation();
            // console.log(data);
            commonConnection = true;
            connectionList = true;
            var _this = $(this);
            var type = $(this).data('type');
            var code = $(this).data('code');
            var name = $(this).data('name');
            var id = $(this).data('id');
            var date = (new Date()).Format("yyyy-MM-dd hh:mm:ss.S");
            if ($(this).hasClass('layui-icon-rate')) {
                //未收藏，收藏
                $.ajax({
                    type: "PUT",
                    url: getContextPath() + "/rest/v1.0/collect/user",
                    dataType: "json",
                    contentType: "application/json",
                    data: JSON.stringify({
                        "code": code,
                        "content": "",
                        "createAt": date,
                        "id": id,
                        "name": name,
                        "typeName": name
                    }),
                    success: function (data) {
                        // console.log(data);
                        layer.msg('收藏成功');
                        _this.removeClass('layui-icon-rate bdc-visible').addClass('layui-icon-rate-solid');
                    },error: function(e){
                        if(e.status==500){
                            var responseText = JSON.parse(e.responseText);
                            layer.msg(responseText.msg);
                        }else{
                            layer.msg('请求异常！');
                        }
                    }
                });
            } else {
                //已收藏 取消收藏
                $.ajax({
                    type: "post",
                    url: getContextPath() + "/rest/v1.0/collect/user",
                    data: {
                        _method: "DELETE",
                        "code": code
                    },
                    success: function (data) {
                        // console.log(data);
                        layer.msg('取消收藏成功');
                        _this.removeClass('layui-icon-rate-solid bdc-visible').addClass('layui-icon-rate');
                    },error: function(e){
                        if(e.status==500){
                            var responseText = JSON.parse(e.responseText);
                            layer.msg(responseText.msg);
                        }else{
                            layer.msg('请求异常！');
                        }
                    }
                });
            }
        });

        //4.5.4 单击 收起 或 展开
        $buildTask.on('click', '.bdc-details-type-tool>.bdc-retract', function () {
            $(this).addClass('bdc-hide').siblings().removeClass('bdc-hide').parents('.bdc-details-type').find('.bdc-details-type-content').height('30px');
        });
        $buildTask.on('click', '.bdc-details-type-tool>.bdc-open', function () {
            $(this).addClass('bdc-hide').siblings().removeClass('bdc-hide').parents('.bdc-details-type').find('.bdc-details-type-content').height('auto');
        });
        //4.5.5 单击二级小类
        $buildTask.on('click','.bdc-details-type-content>a',function () {
            var useData = {
                processDefKey: $(this).find('.layui-icon').data('code'),
                name: $(this).find('.layui-icon').data('name')
            };
            console.log(useData);
            startUpProcess(useData);
        });

        $buildCollectionTask.on('click','.bdc-collection-content>a',function () {
            var useData = {
                processDefKey: $(this).find('.layui-icon').data('code'),
                name: $(this).find('.layui-icon').data('name')
            };
            console.log(useData);
            startUpProcess(useData);
        });

        //4.5.6 点击搜索 input框
        $('.bdc-task-search-box .layui-input').on('focus',function () {
            $(this).siblings('.layui-icon-close').removeClass('bdc-hide');
            $('.bdc-task-tab .bdc-task-tools').animate({'width':'95%'});
            $('.bdc-task-tab>.layui-tab-title>li').css('visibility','hidden');
            $('.bdc-task-content').addClass('bdc-hide');
            $('.bdc-search-content').removeClass('bdc-hide');
        });
        //监听回车事件
        $('.bdc-task-search-box .layui-input').bind('keyup', function(event) {
            if (event.keyCode == "13") {
                //回车执行查询
                $('.bdc-search-content').html('');
                var inputText = $(this).val();
                renderSearchList(inputText);
            }
        });
        //监听 搜索
        $('.bdc-task-search-box .layui-input').bind('input propertychange', function(event) {
            var inputText = $(this).val();
            if(inputText!=''&& inputText!=null){
                renderSearchList(inputText);
            }
        });
        function renderSearchList(processDefName) {
            $.ajax({
                type: "GET",
                url: getContextPath() + "/rest/v1.0/task/list",
                data: {
                    processDefName: processDefName
                },
                success: function (data) {
                    // console.log(data);
                    var getSearchTpl = searchTpl.innerHTML
                        ,searchView = document.getElementById('searchView');
                    laytpl(getSearchTpl).render(data, function(html){
                        searchView.innerHTML = html;
                    });
                },error: function(e){
                    if(e.status==500){
                        var responseText = JSON.parse(e.responseText);
                        layer.msg(responseText.msg);
                    }else{
                        layer.msg('请求异常！');
                    }
                }
            });
        }
        //4.5.7 点击搜索框的删除
        $('.bdc-task-search-box .layui-icon-close').on('click',function () {
            $('.bdc-task-search-box .layui-input').val('');
            $(this).addClass('bdc-hide');
            $('.bdc-task-tab .bdc-task-tools').animate({'width':'310px'});
            $('.bdc-task-tab>.layui-tab-title>li').css('visibility','visible');
            $('.bdc-task-content').removeClass('bdc-hide');
            $('.bdc-search-content').addClass('bdc-hide').html('');

            if (commonConnection) {
                renderLbList();
            }
            if (connectionList) {
                renderCommonCollection();
            }
        });

        //5. 点击 高级查询
        $('#seniorSearch').on('click', function () {
            $('.pf-senior-show').toggleClass('bdc-hide');
        });

        //6. 渲染表格
        // 6.1 待办表格
        var waitUrl = getContextPath() + "/rest/v1.0/task/todo";
        var waitTableId = '#waitTable';
        var waitCurrentId = 'dbTable';
        var waitToolbar = '#toolbarDemo';
        renderWaitTable(waitUrl, waitTableId, waitCurrentId, waitToolbar);

        // 6.2 已办表格
        var doneUrl = getContextPath() + "/rest/v1.0/task/complete";
        var doneTableId = '#doneTable';
        var doneCurrentId = 'doneTableId';
        var doneToolbar = '#toolbarDoneDemo';
        renderDoneTable(doneUrl, doneTableId, doneCurrentId, doneToolbar);
        // 6.3 项目列表表格
        var listUrl = getContextPath() + "/rest/v1.0/task/all";
        var listTableId = '#listTable';
        var listCurrentId = 'listTableId';
        var allToolbar = '#toolbarAllDemo';
        renderListTable(listUrl, listTableId, listCurrentId, allToolbar);
        // 6.4 认领列表表格
        var rlUrl = getContextPath() + "/rest/v1.0/task/claim/list";
        var rlTableId = '#rlTable';
        var rlCurrentId = 'rlTableId';
        var rlTableToolbar = '#rlTableToolbar';
        renderRlTable(rlUrl, rlTableId, rlCurrentId, rlTableToolbar);

        var doneIndex = 0,
            listIndex = 0,
            rlindex = 0;
        //监听第一次单击任务栏tab，重构表格尺寸
        element.on('tab(listFilter)', function (data) {
            if(data.index == 0) {
                renderWaitTable(waitUrl, waitTableId, waitCurrentId, waitToolbar);
            } else if (data.index == 1) {
                if (doneIndex == 0) {
                    doneIndex++;
                    table.resize(doneCurrentId);
                }
                renderDoneTable(doneUrl, doneTableId, doneCurrentId, doneToolbar);
            } else if (data.index == 2) {
                if (listIndex == 0) {
                    listIndex++;
                    table.resize(listCurrentId);
                }
                renderListTable(listUrl, listTableId, listCurrentId, allToolbar);
            } else if (data.index == 3) {
                if (rlindex == 0) {
                    rlindex++;
                    table.resize(rlCurrentId);
                }
                renderRlTable(rlUrl, rlTableId, rlCurrentId, rlTableToolbar);
            }

        });

        //渲染待办表格
        function renderWaitTable(url, tableId, currentId, toolbar) {
            table.render({
                elem: tableId,
                id: currentId,
                url: url,
                toolbar: toolbar,
                title: '待办任务表格',
                method: 'post',
                request: {
                    limitName: 'size' //每页数据量的参数名，默认：limit
                },
                defaultToolbar: ['filter'],
                cols: [[
                    {type: 'checkbox', width: 50, fixed: 'left'},
                    {field: 'text1', title: '受理编号'},
                    {field: 'text3', title: '权利人'},
                    {field: 'text4', title: '坐落'},
                    {title: '流程名称', templet: '#lcTpl', minWidth: 160},
                    {field: 'text2', title: '不动产单元号'},
                    {field: 'taskAssName', title: '处理人'},
                    {field: 'taskName', title: '节点名称'},
                    {field: 'newStartTime', title: '开始时间', sort: true},
                    {field: 'taskTimeoutStatusName', title: '超期状态'},
                    {field: '', title: '流程状态', templet: '#stateTpl', width: 100},
                    {title: '项目名称', templet: '#rwNameTpl', minWidth: 200, hide: true},
                    {field: 'category', title: '业务类型', hide: true},
                    {field: 'delegationName', title: '委托状态', hide: true},
                    {field: 'claimStatusName', title: '认领状态', hide: true},
                    {field: 'procInsId', title: '工作流实例ID', hide: true}
                ]],
                parseData: function (res) { //res 即为原始返回的数据
                    // console.log(res);
                    if (currentId == 'dbTable') {
                        $('.bdc-list-num-tips').html(res.totalElements);
                    }
                    res.content.forEach(function (v) {
                        if (v.startTime) {
                            var newStartTime = new Date(v.startTime);
                            v.newStartTime = newStartTime.toLocaleString();
                        }
                    });
                    return {
                        "code": res.code, //解析接口状态
                        "msg": res.message, //解析提示文本
                        "count": res.totalElements, //解析数据长度
                        "data": res.content //解析数据列表
                    };
                },
                page: true,
                done: function () {
                    $('.layui-table-tool-self').css('right', $('.bdc-export-tools').width() + 17 + 'px');
                }
            });
        }

        //渲染已办表格
        function renderDoneTable(url, tableId, currentId, toolbar) {
            table.render({
                elem: tableId,
                id: currentId,
                url: url,
                toolbar: toolbar,
                title: '用户数据表',
                method: 'post',
                request: {
                    limitName: 'size' //每页数据量的参数名，默认：limit
                },
                defaultToolbar: ['filter'],
                cols: [[
                    {type: 'checkbox', width: 50, fixed: 'left'},
                    {field: 'text1', title: '受理编号'},
                    {field: 'text3', title: '权利人'},
                    {field: 'text2', title: '不动产单元号'},
                    {field: 'text4', title: '坐落'},
                    {title: '流程名称', templet: '#lcTpl', minWidth: 160},
                    {field: 'newStartTime', title: '开始时间', sort: true},
                    {field: 'newEndTime', title: '结束时间', sort: true},
                    {title: '项目名称', templet: '#rwNameTpl', minWidth: 200, hide: true},
                    {field: 'taskName', title: '任务名称', hide: true},
                    {field: 'category', title: '业务类型', hide: true},
                    {field: 'procStartUserName', title: '创建人', hide: true},
                    {field: 'taskAssName', title: '处理人', hide: true},
                    {field: 'procInsId', title: '工作流实例ID', hide: true}
                ]],
                parseData: function (res) { //res 即为原始返回的数据
                    // console.log(res);
                    if (currentId == 'dbTable') {
                        $('.bdc-list-num-tips').html(res.totalElements);
                    }
                    res.content.forEach(function (v) {
                        if (v.startTime) {
                            var newStartTime = new Date(v.startTime);
                            v.newStartTime = newStartTime.toLocaleString();
                        }
                        if (v.endTime) {
                            var newEndTime = new Date(v.endTime);
                            v.newEndTime = newEndTime.toLocaleString();
                        }
                    });
                    return {
                        "code": res.code, //解析接口状态
                        "msg": res.message, //解析提示文本
                        "count": res.totalElements, //解析数据长度
                        "data": res.content //解析数据列表
                    };
                },
                page: true,
                done: function () {
                    $('.layui-table-tool-self').css('right', $('.bdc-export-tools').width() + 17 + 'px');
                }
            });
        }

        //渲染项目列表
        function renderListTable(url, tableId, currentId, toolbar) {
            table.render({
                elem: tableId,
                id: currentId,
                url: url,
                toolbar: toolbar,
                title: '用户数据表',
                method: 'post',
                request: {
                    limitName: 'size' //每页数据量的参数名，默认：limit
                },
                defaultToolbar: ['filter'],
                cols: [[
                    {type: 'checkbox', width: 50, fixed: 'left'},
                    {field: 'text1', title: '受理编号', hide: true},
                    {field: 'text3', title: '权利人', hide: true},
                    {field: 'text2', title: '不动产单元号', hide: true},
                    {field: 'text4', title: '坐落', hide: true},
                    {title: '流程名称', templet: '#lcTpl', minWidth: 160},
                    {field: 'startTime', title: '开始时间', sort: true},
                    {field: 'endTime', title: '结束时间', sort: true},
                    {title: '项目名称', templet: '#rwNameTpl', minWidth: 200},
                    {field: 'processInstanceName', title: '任务名称'},
                    {field: 'categoryName', title: '业务类型'},
                    {field: 'startUserName', title: '创建人'},
                    {field: 'procInsId', title: '工作流实例ID'}
                ]],
                parseData: function (res) { //res 即为原始返回的数据
                    // console.log(res);
                    if (currentId == 'dbTable') {
                        $('.bdc-list-num-tips').html(res.totalElements);
                    }
                    res.content.forEach(function (v) {
                        if (v.startTime) {
                            var startNewTime = new Date(v.startTime);
                            v.startTime = startNewTime.toLocaleString();
                        }
                        if (v.endTime) {
                            var newEndTime = new Date(v.endTime);
                            v.endTime = newEndTime.toLocaleString();
                        }
                    });
                    return {
                        "code": res.code, //解析接口状态
                        "msg": res.message, //解析提示文本
                        "count": res.totalElements, //解析数据长度
                        "data": res.content //解析数据列表
                    };
                },
                page: true,
                done: function () {
                    $('.layui-table-tool-self').css('right', $('.bdc-export-tools').width() + 17 + 'px');
                }
            });
        }

        function renderRlTable(url, tableId, currentId, toolbar) {
            table.render({
                elem: tableId,
                id: currentId,
                url: url,
                toolbar: toolbar,
                title: '认领任务表',
                method: 'post',
                request: {
                    limitName: 'size' //每页数据量的参数名，默认：limit
                },
                defaultToolbar: ['filter'],
                cols: [[
                    {type: 'checkbox', width: 50, fixed: 'left'},
                    {field: 'text1', title: '受理编号'},
                    {field: 'text3', title: '权利人'},
                    {field: 'text2', title: '不动产单元号'},
                    {field: 'text4', title: '坐落'},
                    {title: '流程名称', templet: '#lcTpl', minWidth: 160},
                    {field: 'newStartTime', title: '开始时间', sort: true},
                    {field: 'newEndTime', title: '结束时间', sort: true},
                    {title: '项目名称', templet: '#rwNameTpl', minWidth: 200, hide: true},
                    {field: 'taskName', title: '任务名称', hide: true},
                    {field: 'category', title: '业务类型', hide: true},
                    {field: 'procStartUserName', title: '创建人', hide: true},
                    {field: 'taskAssName', title: '处理人', hide: true},
                    {field: 'procInsId', title: '工作流实例ID', hide: true}
                ]],
                parseData: function (res) { //res 即为原始返回的数据
                    res.content.forEach(function (v) {
                        if (v.startTime) {
                            var newStartTime = new Date(v.startTime);
                            v.newStartTime = newStartTime.toLocaleString();
                        }
                        if (v.endTime) {
                            var newEndTime = new Date(v.endTime);
                            v.newEndTime = newEndTime.toLocaleString();
                        }
                    });
                    return {
                        "code": res.code, //解析接口状态
                        "msg": res.message, //解析提示文本
                        "count": res.totalElements, //解析数据长度
                        "data": res.content //解析数据列表
                    };
                },
                page: true,
                done: function () {
                    $('.layui-table-tool-self').css('right', $('.bdc-export-tools').width() + 17 + 'px');
                }
            });
        }

        //6.4 待办任务头工具栏事件
        table.on('toolbar(waitTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            if (obj.event != "LAYTABLE_COLS") {
                if (checkStatus.data.length != 1) {
                    layer.msg('请选择一条数据进行操作！');
                    return false;
                }
            }
            var checkData = checkStatus.data[0];
            switch (obj.event) {
                case 'forward-process':
                    forwardProcess(checkData, waitUrl, waitTableId, waitCurrentId);
                    break;
                case 'back-process':
                    backProcess(checkData, waitUrl, waitTableId, waitCurrentId);
                    break;
                case 'active-process':
                    // 激活流程
                    activeProcess(checkData, waitUrl, waitTableId, waitCurrentId);
                    break;
                case 'delete-process':
                    // 删除当前任务
                    deleteProcess(checkData, waitUrl, waitTableId, waitCurrentId);
                    break;
                case 'hang-up-process':
                    hangUpProcess(checkData, waitUrl, waitTableId, waitCurrentId);
                    break;
                case 'claim-process':
                    claimProcess(checkData, waitUrl, waitTableId, waitCurrentId);
                    break;
            }
        });
        //认领工具栏
        table.on('toolbar(rlTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            // if (obj.event != "LAYTABLE_COLS") {
            //     if (checkStatus.data.length != 1) {
            //         layer.msg('请选择一条数据进行操作！');
            //         return false;
            //     }
            // }
            switch (obj.event) {
                case 'claim-process':
                    claimProcess(checkStatus, rlUrl, rlTableId, rlCurrentId);
                    break;
            }
        });
        //已办 工具类
        table.on('toolbar(doneTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            if (obj.event != "LAYTABLE_COLS") {
                if (checkStatus.data.length != 1) {
                    layer.msg('请选择一条数据进行操作！');
                    return false;
                }
            }
            var checkData = checkStatus.data[0];
            switch (obj.event) {
                case 'fetch-process':
                        fetchProcess(checkData, doneUrl, doneTableId, doneCurrentId);
                    break;
            }
        });

        // 6.5 监听行双击事件
        //监听待办 行双击
        table.on('rowDouble(waitTableFilter)', function (obj) {
            console.log(obj.data); //得到当前行数据
            var lcArray = {
                taskId: obj.data.taskId,
                formKey: obj.data.formKey,
                processInstanceId: obj.data.processInstanceId,
                processDefName: obj.data.processDefName,
                processInstanceType: 'todo'
            };
            sessionStorage.setItem('lcArray' + obj.data.taskId, JSON.stringify(lcArray));
            window.open(getContextPath() + "/view/new-page.html?name=" + obj.data.taskId);
        });
        // 监听已办 行双击
        table.on('rowDouble(doneTableFilter)', function (obj) {
            console.log(obj.data); //得到当前行数据
            var lcArray = {
                taskId: obj.data.taskId,
                formKey: obj.data.formKey,
                processInstanceId: obj.data.processInstanceId,
                processDefName: obj.data.processDefName,
                processInstanceType: 'done'
            };
            sessionStorage.setItem('lcArray' + obj.data.taskId, JSON.stringify(lcArray));
            window.open(getContextPath() + "/view/new-page.html?name=" + obj.data.taskId);
        });
        // 监听项目列表 行双击
        table.on('rowDouble(listTableFilter)', function (obj) {
            console.log(obj.data); //得到当前行数据
            var listArray = {
                processInstanceId: obj.data.procInsId,
                processDefName: obj.data.processDefName,
                processInstanceType: 'list'
            };
            sessionStorage.setItem('listArray' + obj.data.procInsId, JSON.stringify(listArray));
            window.open(getContextPath() + "/view/new-page.html?name=" + obj.data.procInsId);
        });

        //查询
        var searchObj={"dbSearch":"dbTable","ybSearch":"doneTableId","xmSearch":"listTableId","rlSearch":"rlTableId"};
        $('.searchBtn').on('click', function () {
            var id=this.id;
            // 获取查询内容
            var obj = {};
            $("."+id).each(function (i) {
                var value = $(this).val();
                var name = $(this).attr('name');
                obj[name] = value;
            });
            // 重新请求
            console.log(searchObj[id]);
            table.reload(searchObj[id], {
                where: obj
                , page: {
                    curr: 1  //重新从第 1 页开始
                }
            });
        });


        //点击高级查询
        $('#senior').on('click', function () {
            $('.bdc-senior-show').toggleClass('bdc-hide');
        });


        //解决跨域问题
        $('.layui-side').on('click','.bdc-show-msg',function () {
            setTimeout(function () {
                $('.layadmin-tabsbody-item:last-child').append('<iframe id="test2" src="" frameborder="0" width="100%" height="0"></iframe>');
            },1000);
        });

        //点击自己出的 删除
        $('.bdc-outer-tab').on('click', '.bdc-tab-close', function () {
            // console.log($(this).parent().index());
            var _this = $(this).parent();
            var nowIndex = _this.index() + 1;
            if (_this.hasClass('layui-this')) {
                var nextLiIndex = nowIndex + 1;
                _this.parent().find('li').removeClass('layui-this');
                _this.parent().find('li:nth-child(' + nextLiIndex + ')').addClass('layui-this');
                _this.remove();
                $('.layui-body .layadmin-tabsbody-item:nth-child(' + nowIndex + ')').remove();
                $('.layui-body .layadmin-tabsbody-item').removeClass('layui-show');
                $('.layui-body .layadmin-tabsbody-item:nth-child(' + nowIndex + ')').addClass('layui-show');
            } else {
                _this.remove();
                $('.layui-body .layadmin-tabsbody-item:nth-child(' + nowIndex + ')').remove();
            }

        });

    });
});