/**
 * @author <a href ="mailto:songhaowen@gtmap.cn">songhaowen</a>
 * @description 退回详情页面
 */
layui.use(['jquery', 'table', 'element', 'form', 'laytpl'], function () {
    var $ = layui.jquery,
        table = layui.table,
        laytpl = layui.laytpl,
        form = layui.form;

    $(function () {
        //获取地址栏参数
        var $paramArr = [];

        function getIpHz() {
            var $params = window.location.search.replace('?', '');
            var $paramSplit = $params.split('&');
            for (var i in $paramSplit) {
                var $subParam = $paramSplit[i].split('=');
                $paramArr[$subParam[0]] = $subParam[1];
            }
        }

        getIpHz();
        var getName = $paramArr['name'];
        //获取session数据
        var lcArray = '',
            taskId = $paramArr['taskId'];
        if (sessionStorage.getItem('lcArray' + getName)) {
            lcArray = JSON.parse(sessionStorage.getItem('lcArray' + getName));
        }

        //获取表格选择类型
        var col = [[
            {type: 'checkbox', width: 50, fixed: 'left'},
            {field: 'activityId', title: '', hide: true},
            {field: 'taskId', title: '', hide: true},
            {field: 'activityName', title: '退回节点'}
        ]]
        //获取转发内容
        $.ajax({
            type: "GET",
            async: false,
            url: getContextPath() + "/rest/v1.0/workflow/process-instances/back/userTasks",
            data: {
                taskId: taskId
            },
            success: function (data) {
                if (data) {
                    renderZfTable(data, col);
                } else {
                    $('#backContainer').addClass('bdc-hide');
                    $('#backOpinionContainer').removeClass('bdc-hide');
                }
            },
            error: function (e) {
                if(e.status==500){
                    var responseText = JSON.parse(e.responseText);
                    layer.msg(responseText.msg);
                }else{
                    layer.msg('请求异常！');
                }

            }
        });

        function renderZfTable(data, col) {
            table.render({
                elem: '#checkboxTable',
                id: 'checkBoxTableId',
                cols: col,
                data: data
            });
        }

        //点击转发
        $('.bdc-back-btn').on('click', function () {
            var checkStatus = table.checkStatus('checkBoxTableId'); //idTest 即为基础参数 id 对应的值
            var backTaskDtos = checkStatus.data;
            var success = '退回成功！';
            var fail = '退回失敗！';
            var opinion = $('.backopinion').val();
            backTaskDtos.forEach(function (value) {
                value.taskId = taskId;
                value.opinion = opinion;
            });
            $.ajax({
                type: "POST",
                async: false,
                contentType: "application/json;charset=utf-8",
                url: getContextPath() + "/rest/v1.0/workflow/process-instances/back",
                data: JSON.stringify(backTaskDtos),
                success: function () {
                    layer.msg(success,
                        {
                            time: 1000
                        }, function () {
                            closeParentWindow();
                        })

                }, error: function (e) {
                    if(e.status==500){
                        var responseText = JSON.parse(e.responseText);
                        layer.msg(responseText.msg);
                    }else{
                        layer.msg('请求异常！');
                    }
                }
            });
        })

        /**
         * 关闭弹出页面
         */
        $('.bdc-back-cancel').on('click', function () {
            closeParentWindow();
        })

    });
});